/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.queue.mongo;

import com.github.ltsopensource.admin.request.JobQueueReq;
import com.github.ltsopensource.admin.response.PaginationRsp;
import com.github.ltsopensource.core.cluster.Config;
import com.github.ltsopensource.core.commons.utils.Assert;
import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.core.support.SystemClock;
import com.github.ltsopensource.queue.JobQueue;
import com.github.ltsopensource.queue.domain.JobPo;
import com.github.ltsopensource.store.mongo.MongoRepository;
import java.util.Date;
import java.util.HashMap;
import org.mongodb.morphia.query.Query;
import org.mongodb.morphia.query.UpdateOperations;
import org.mongodb.morphia.query.UpdateResults;

public abstract class AbstractMongoJobQueue
extends MongoRepository
implements JobQueue {
    public AbstractMongoJobQueue(Config config) {
        super(config);
    }

    @Override
    public PaginationRsp<JobPo> pageSelect(JobQueueReq request) {
        Query<JobPo> query = this.template.createQuery(this.getTargetTable(request.getTaskTrackerNodeGroup()), JobPo.class);
        this.addCondition(query, "jobId", request.getJobId());
        this.addCondition(query, "taskId", request.getTaskId());
        this.addCondition(query, "realTaskId", request.getRealTaskId());
        this.addCondition(query, "taskTrackerNodeGroup", request.getTaskTrackerNodeGroup());
        this.addCondition(query, "jobType", request.getJobType());
        this.addCondition(query, "submitNodeGroup", request.getSubmitNodeGroup());
        this.addCondition(query, "needFeedback", request.getNeedFeedback());
        if (request.getStartGmtCreated() != null) {
            query.filter("gmtCreated >= ", (Object)request.getStartGmtCreated().getTime());
        }
        if (request.getEndGmtCreated() != null) {
            query.filter("gmtCreated <= ", (Object)request.getEndGmtCreated().getTime());
        }
        if (request.getStartGmtModified() != null) {
            query.filter("gmtModified <= ", (Object)request.getStartGmtModified().getTime());
        }
        if (request.getEndGmtModified() != null) {
            query.filter("gmtModified >= ", (Object)request.getEndGmtModified().getTime());
        }
        PaginationRsp<JobPo> response = new PaginationRsp<JobPo>();
        Long results = this.template.getCount(query);
        response.setResults(results.intValue());
        if (results == 0L) {
            return response;
        }
        if (StringUtils.isNotEmpty(request.getField()) && StringUtils.isNotEmpty(request.getDirection())) {
            query.order(("ASC".equalsIgnoreCase(request.getDirection()) ? "" : "-") + request.getField());
        }
        query.offset(request.getStart().intValue()).limit(request.getLimit().intValue());
        response.setRows(query.asList());
        return response;
    }

    @Override
    public boolean selectiveUpdateByJobId(JobQueueReq request) {
        Assert.hasLength(request.getJobId(), "Only allow update by jobId");
        Query<JobPo> query = this.template.createQuery(this.getTargetTable(request.getTaskTrackerNodeGroup()), JobPo.class);
        query.field("jobId").equal((Object)request.getJobId());
        UpdateOperations<JobPo> operations = this.buildUpdateOperations(request);
        UpdateResults ur = this.template.update(query, operations);
        return ur.getUpdatedCount() == 1;
    }

    private UpdateOperations<JobPo> buildUpdateOperations(JobQueueReq request) {
        UpdateOperations<JobPo> operations = this.template.createUpdateOperations(JobPo.class);
        this.addUpdateField(operations, "cronExpression", request.getCronExpression());
        this.addUpdateField(operations, "needFeedback", request.getNeedFeedback());
        this.addUpdateField(operations, "extParams", request.getExtParams());
        this.addUpdateField(operations, "triggerTime", request.getTriggerTime() == null ? null : Long.valueOf(request.getTriggerTime().getTime()));
        this.addUpdateField(operations, "priority", request.getPriority());
        this.addUpdateField(operations, "maxRetryTimes", request.getMaxRetryTimes());
        this.addUpdateField(operations, "relyOnPrevCycle", request.getRelyOnPrevCycle() == null ? true : request.getRelyOnPrevCycle());
        this.addUpdateField(operations, "submitNodeGroup", request.getSubmitNodeGroup());
        this.addUpdateField(operations, "taskTrackerNodeGroup", request.getTaskTrackerNodeGroup());
        this.addUpdateField(operations, "repeatCount", request.getRepeatCount());
        this.addUpdateField(operations, "repeatInterval", request.getRepeatInterval());
        this.addUpdateField(operations, "gmtModified", SystemClock.now());
        return operations;
    }

    @Override
    public boolean selectiveUpdateByTaskId(JobQueueReq request) {
        Assert.hasLength(request.getRealTaskId(), "Only allow update by realTaskId and taskTrackerNodeGroup");
        Assert.hasLength(request.getTaskTrackerNodeGroup(), "Only allow update by realTaskId and taskTrackerNodeGroup");
        Query<JobPo> query = this.template.createQuery(this.getTargetTable(request.getTaskTrackerNodeGroup()), JobPo.class);
        query.field("realTaskId").equal((Object)request.getRealTaskId());
        query.field("taskTrackerNodeGroup").equal((Object)request.getTaskTrackerNodeGroup());
        UpdateOperations<JobPo> operations = this.buildUpdateOperations(request);
        UpdateResults ur = this.template.update(query, operations);
        return ur.getUpdatedCount() == 1;
    }

    private Query<JobPo> addCondition(Query<JobPo> query, String field, Object o) {
        if (!this.checkCondition(o)) {
            return query;
        }
        query.field(field).equal(o);
        return query;
    }

    private UpdateOperations<JobPo> addUpdateField(UpdateOperations<JobPo> operations, String field, Object o) {
        if (!this.checkCondition(o)) {
            return operations;
        }
        operations.set(field, o);
        return operations;
    }

    private boolean checkCondition(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof String) {
            return !StringUtils.isEmpty((String)obj);
        }
        if (obj instanceof Integer || obj instanceof Boolean || obj instanceof Long || obj instanceof Float || obj instanceof Date || obj instanceof HashMap) {
            return true;
        }
        throw new IllegalArgumentException("Can not support type " + obj.getClass());
    }

    protected abstract String getTargetTable(String var1);
}

