/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.queue.mysql;

import com.github.ltsopensource.admin.request.JobQueueReq;
import com.github.ltsopensource.core.cluster.Config;
import com.github.ltsopensource.queue.SuspendJobQueue;
import com.github.ltsopensource.queue.domain.JobPo;
import com.github.ltsopensource.queue.mysql.AbstractMysqlJobQueue;
import com.github.ltsopensource.queue.mysql.support.RshHolder;
import com.github.ltsopensource.store.jdbc.builder.DeleteSql;
import com.github.ltsopensource.store.jdbc.builder.SelectSql;

public class MysqlSuspendJobQueue
extends AbstractMysqlJobQueue
implements SuspendJobQueue {
    public MysqlSuspendJobQueue(Config config) {
        super(config);
        this.createTable(this.readSqlFile("sql/mysql/lts_suspend_job_queue.sql", this.getTableName()));
    }

    @Override
    protected String getTableName(JobQueueReq request) {
        return this.getTableName();
    }

    @Override
    public boolean add(JobPo jobPo) {
        return this.add(this.getTableName(), jobPo);
    }

    @Override
    public JobPo getJob(String jobId) {
        return new SelectSql(this.getSqlTemplate()).select().all().from().table(this.getTableName()).where("job_id = ?", jobId).single(RshHolder.JOB_PO_RSH);
    }

    @Override
    public boolean remove(String jobId) {
        return new DeleteSql(this.getSqlTemplate()).delete().from().table(this.getTableName()).where("job_id = ?", jobId).doDelete() == 1;
    }

    @Override
    public JobPo getJob(String taskTrackerNodeGroup, String taskId) {
        return new SelectSql(this.getSqlTemplate()).select().all().from().table(this.getTableName()).where("task_id = ?", taskId).and("task_tracker_node_group = ?", taskTrackerNodeGroup).single(RshHolder.JOB_PO_RSH);
    }

    private String getTableName() {
        return "lts_suspend_job_queue";
    }
}

