/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.queue.support;

import com.github.ltsopensource.core.commons.utils.DateUtils;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.core.support.CronExpressionUtils;
import com.github.ltsopensource.core.support.JobUtils;
import com.github.ltsopensource.queue.CronJobQueue;
import com.github.ltsopensource.queue.ExecutableJobQueue;
import com.github.ltsopensource.queue.RepeatJobQueue;
import com.github.ltsopensource.queue.domain.JobPo;
import com.github.ltsopensource.store.jdbc.exception.DupEntryException;
import java.util.Date;

public class NonRelyJobUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(NonRelyJobUtils.class);

    public static void addCronJobForInterval(ExecutableJobQueue executableJobQueue, CronJobQueue cronJobQueue, int scheduleIntervalMinute, JobPo finalJobPo, Date lastGenerateTime) {
        JobPo jobPo = JobUtils.copy(finalJobPo);
        String cronExpression = jobPo.getCronExpression();
        long endTime = DateUtils.addMinute(lastGenerateTime, scheduleIntervalMinute).getTime();
        Date timeAfter = lastGenerateTime;
        boolean stop = false;
        while (!stop) {
            Date nextTriggerTime = CronExpressionUtils.getNextTriggerTime(cronExpression, timeAfter);
            if (nextTriggerTime == null) {
                stop = true;
            } else if (nextTriggerTime.getTime() <= endTime) {
                jobPo.setTriggerTime(nextTriggerTime.getTime());
                jobPo.setJobId(JobUtils.generateJobId());
                jobPo.setTaskId(finalJobPo.getTaskId() + "_" + DateUtils.format(nextTriggerTime, "MMdd-HHmmss"));
                jobPo.setInternalExtParam("__LTS_ONCE", Boolean.TRUE.toString());
                try {
                    jobPo.setInternalExtParam("__LTS_Seq_Id", JobUtils.generateExeSeqId(jobPo));
                    executableJobQueue.add(jobPo);
                }
                catch (DupEntryException e) {
                    LOGGER.warn("Cron Job[taskId={}, taskTrackerNodeGroup={}] Already Exist in ExecutableJobQueue", jobPo.getTaskId(), jobPo.getTaskTrackerNodeGroup());
                }
            } else {
                stop = true;
            }
            timeAfter = nextTriggerTime;
        }
        cronJobQueue.updateLastGenerateTriggerTime(finalJobPo.getJobId(), endTime);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Add CronJob {} to {}", jobPo, DateUtils.formatYMD_HMS(new Date(endTime)));
        }
    }

    public static void addRepeatJobForInterval(ExecutableJobQueue executableJobQueue, RepeatJobQueue repeatJobQueue, int scheduleIntervalMinute, JobPo finalJobPo, Date lastGenerateTime) {
        JobPo jobPo = JobUtils.copy(finalJobPo);
        long firstTriggerTime = Long.valueOf(jobPo.getInternalExtParam("__LTS_Repeat_Job_First_Fire_Time"));
        Long repeatInterval = jobPo.getRepeatInterval();
        Integer repeatCount = jobPo.getRepeatCount();
        long endTime = DateUtils.addMinute(lastGenerateTime, scheduleIntervalMinute).getTime();
        if (endTime <= firstTriggerTime) {
            return;
        }
        int repeatedCount = Long.valueOf((lastGenerateTime.getTime() - firstTriggerTime) / jobPo.getRepeatInterval()).intValue();
        boolean stop = false;
        while (!stop) {
            Long nextTriggerTime = firstTriggerTime + (long)repeatedCount * repeatInterval;
            if (nextTriggerTime <= endTime && (repeatCount == -1 || repeatedCount <= repeatCount)) {
                jobPo.setTriggerTime(nextTriggerTime);
                jobPo.setJobId(JobUtils.generateJobId());
                jobPo.setTaskId(finalJobPo.getTaskId() + "_" + DateUtils.format(new Date(nextTriggerTime), "MMdd-HHmmss"));
                jobPo.setRepeatedCount(repeatedCount);
                jobPo.setInternalExtParam("__LTS_ONCE", Boolean.TRUE.toString());
                try {
                    jobPo.setInternalExtParam("__LTS_Seq_Id", JobUtils.generateExeSeqId(jobPo));
                    executableJobQueue.add(jobPo);
                }
                catch (DupEntryException e) {
                    LOGGER.warn("Repeat Job[taskId={}, taskTrackerNodeGroup={}] Already Exist in ExecutableJobQueue", jobPo.getTaskId(), jobPo.getTaskTrackerNodeGroup());
                }
                ++repeatedCount;
                continue;
            }
            stop = true;
        }
        repeatJobQueue.updateLastGenerateTriggerTime(finalJobPo.getJobId(), endTime);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Add RepeatJob {} to {}", jobPo, DateUtils.formatYMD_HMS(new Date(endTime)));
        }
    }
}

