/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.remoting.lts;

import com.github.ltsopensource.nio.NioClient;
import com.github.ltsopensource.nio.channel.ChannelInitializer;
import com.github.ltsopensource.nio.codec.Decoder;
import com.github.ltsopensource.nio.codec.Encoder;
import com.github.ltsopensource.nio.config.NioClientConfig;
import com.github.ltsopensource.nio.handler.Futures;
import com.github.ltsopensource.remoting.AbstractRemotingClient;
import com.github.ltsopensource.remoting.ChannelEventListener;
import com.github.ltsopensource.remoting.ChannelFuture;
import com.github.ltsopensource.remoting.RemotingClientConfig;
import com.github.ltsopensource.remoting.exception.RemotingException;
import com.github.ltsopensource.remoting.lts.LtsChannelFuture;
import com.github.ltsopensource.remoting.lts.LtsCodecFactory;
import com.github.ltsopensource.remoting.lts.LtsEventHandler;
import java.net.SocketAddress;

public class LtsRemotingClient
extends AbstractRemotingClient {
    private NioClient client;

    public LtsRemotingClient(RemotingClientConfig remotingClientConfig, ChannelEventListener channelEventListener) {
        super(remotingClientConfig, channelEventListener);
    }

    public LtsRemotingClient(RemotingClientConfig remotingClientConfig) {
        this(remotingClientConfig, null);
    }

    @Override
    protected void clientStart() throws RemotingException {
        NioClientConfig clientConfig = new NioClientConfig();
        clientConfig.setTcpNoDelay(true);
        clientConfig.setIdleTimeBoth(this.remotingClientConfig.getClientChannelMaxIdleTimeSeconds());
        clientConfig.setIdleTimeRead(this.remotingClientConfig.getReaderIdleTimeSeconds());
        clientConfig.setIdleTimeWrite(this.remotingClientConfig.getWriterIdleTimeSeconds());
        final LtsCodecFactory codecFactory = new LtsCodecFactory(this.getCodec());
        this.client = new NioClient(clientConfig, new LtsEventHandler(this, "CLIENT"), new ChannelInitializer(){

            @Override
            protected Decoder getDecoder() {
                return codecFactory.getDecoder();
            }

            @Override
            protected Encoder getEncoder() {
                return codecFactory.getEncoder();
            }
        });
    }

    @Override
    protected void clientShutdown() {
        this.client.shutdownGracefully();
    }

    @Override
    protected ChannelFuture connect(SocketAddress socketAddress) {
        Futures.ConnectFuture connectFuture = this.client.connect(socketAddress);
        return new LtsChannelFuture(connectFuture);
    }
}

