/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.remoting.mina;

import com.github.ltsopensource.remoting.Channel;
import com.github.ltsopensource.remoting.ChannelHandler;
import com.github.ltsopensource.remoting.mina.MinaChannelHandler;
import java.net.SocketAddress;
import org.apache.mina.core.future.CloseFuture;
import org.apache.mina.core.future.IoFuture;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.session.IoSession;

public class MinaChannel
implements Channel {
    private IoSession session;

    public MinaChannel(IoSession session) {
        this.session = session;
    }

    @Override
    public SocketAddress localAddress() {
        return this.session.getLocalAddress();
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.session.getRemoteAddress();
    }

    @Override
    public ChannelHandler writeAndFlush(Object msg) {
        WriteFuture writeFuture = this.session.write(msg);
        return new MinaChannelHandler((IoFuture)writeFuture);
    }

    @Override
    public ChannelHandler close() {
        CloseFuture closeFuture = this.session.close(false);
        return new MinaChannelHandler((IoFuture)closeFuture);
    }

    @Override
    public boolean isConnected() {
        return this.session.isConnected();
    }

    @Override
    public boolean isOpen() {
        return this.session.isConnected();
    }

    @Override
    public boolean isClosed() {
        return this.session.isClosing();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MinaChannel that = (MinaChannel)o;
        return !(this.session == null ? that.session != null : !this.session.equals(that.session));
    }

    public int hashCode() {
        return this.session != null ? this.session.hashCode() : 0;
    }
}

