/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.remoting.mina;

import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.remoting.codec.Codec;
import com.github.ltsopensource.remoting.common.RemotingHelper;
import com.github.ltsopensource.remoting.mina.MinaChannel;
import com.github.ltsopensource.remoting.protocol.RemotingCommand;
import java.nio.ByteBuffer;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.buffer.IoBufferAllocator;
import org.apache.mina.core.buffer.SimpleBufferAllocator;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.CumulativeProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolEncoderAdapter;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;

public class MinaCodecFactory
implements ProtocolCodecFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(MinaCodecFactory.class);
    private Codec codec;
    IoBufferAllocator bufferAllocator = new SimpleBufferAllocator();
    private ProtocolEncoder encoder = new ProtocolEncoderAdapter(){

        public void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws Exception {
            if (message == null) {
                LOGGER.error("Message is null");
                return;
            }
            if (!(message instanceof RemotingCommand)) {
                LOGGER.error("{} is not instanceof RemotingCommand", message);
                return;
            }
            RemotingCommand remotingCommand = (RemotingCommand)message;
            try {
                ByteBuffer byteBuffer = MinaCodecFactory.this.codec.encode(remotingCommand);
                IoBuffer ioBuffer = MinaCodecFactory.this.bufferAllocator.wrap(byteBuffer);
                out.write((Object)ioBuffer);
                out.flush();
            }
            catch (Exception e) {
                MinaChannel channel = new MinaChannel(session);
                LOGGER.error("encode exception, addr={}, remotingCommand={}", RemotingHelper.parseChannelRemoteAddr(channel), remotingCommand.toString(), e);
                RemotingHelper.closeChannel(channel);
            }
        }
    };
    private ProtocolDecoder decoder = new CumulativeProtocolDecoder(){

        protected boolean doDecode(IoSession session, IoBuffer in, ProtocolDecoderOutput out) throws Exception {
            while (in.remaining() > 4) {
                byte[] lengthBytes = new byte[4];
                in.mark();
                in.get(lengthBytes);
                int length = ByteBuffer.wrap(lengthBytes).getInt();
                if (length == 0 || length > in.remaining()) {
                    in.reset();
                    return false;
                }
                byte[] bytes = new byte[length];
                in.get(bytes, 0, length);
                ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
                try {
                    RemotingCommand remotingCommand = MinaCodecFactory.this.codec.decode(byteBuffer);
                    out.write((Object)remotingCommand);
                }
                catch (Exception e) {
                    MinaChannel channel = new MinaChannel(session);
                    LOGGER.error("decode exception, {}", RemotingHelper.parseChannelRemoteAddr(channel), e);
                    RemotingHelper.closeChannel(channel);
                }
            }
            return false;
        }
    };

    public MinaCodecFactory(Codec codec) {
        this.codec = codec;
    }

    public ProtocolEncoder getEncoder(IoSession session) throws Exception {
        return this.encoder;
    }

    public ProtocolDecoder getDecoder(IoSession session) throws Exception {
        return this.decoder;
    }
}

