/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.remoting.mina;

import com.github.ltsopensource.remoting.AbstractRemotingClient;
import com.github.ltsopensource.remoting.ChannelEventListener;
import com.github.ltsopensource.remoting.ChannelFuture;
import com.github.ltsopensource.remoting.RemotingClientConfig;
import com.github.ltsopensource.remoting.exception.RemotingException;
import com.github.ltsopensource.remoting.mina.MinaChannelFuture;
import com.github.ltsopensource.remoting.mina.MinaCodecFactory;
import com.github.ltsopensource.remoting.mina.MinaHandler;
import java.net.SocketAddress;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.logging.MdcInjectionFilter;
import org.apache.mina.transport.socket.SocketSessionConfig;
import org.apache.mina.transport.socket.nio.NioSocketConnector;

public class MinaRemotingClient
extends AbstractRemotingClient {
    private NioSocketConnector connector;

    public MinaRemotingClient(RemotingClientConfig remotingClientConfig) {
        this(remotingClientConfig, null);
    }

    public MinaRemotingClient(RemotingClientConfig remotingClientConfig, ChannelEventListener channelEventListener) {
        super(remotingClientConfig, channelEventListener);
    }

    @Override
    protected void clientStart() throws RemotingException {
        try {
            this.connector = new NioSocketConnector();
            this.connector.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new MinaCodecFactory(this.getCodec())));
            this.connector.getFilterChain().addLast("mdc", (IoFilter)new MdcInjectionFilter());
            this.connector.setHandler((IoHandler)new MinaHandler(this));
            SocketSessionConfig cfg = this.connector.getSessionConfig();
            cfg.setReaderIdleTime(this.remotingClientConfig.getReaderIdleTimeSeconds());
            cfg.setWriterIdleTime(this.remotingClientConfig.getWriterIdleTimeSeconds());
            cfg.setBothIdleTime(this.remotingClientConfig.getClientChannelMaxIdleTimeSeconds());
        }
        catch (Exception e) {
            throw new RemotingException("Mina Client start error", e);
        }
    }

    @Override
    protected void clientShutdown() {
        if (this.connector != null) {
            this.connector.dispose();
        }
    }

    @Override
    protected ChannelFuture connect(SocketAddress socketAddress) {
        ConnectFuture connectFuture = this.connector.connect(socketAddress);
        return new MinaChannelFuture(connectFuture);
    }
}

