/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.remoting.netty;

import com.github.ltsopensource.remoting.Channel;
import com.github.ltsopensource.remoting.ChannelHandler;
import com.github.ltsopensource.remoting.netty.NettyChannelHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import java.net.SocketAddress;

public class NettyChannel
implements Channel {
    private io.netty.channel.Channel channel;

    public NettyChannel(ChannelHandlerContext ctx) {
        this.channel = ctx.channel();
    }

    public NettyChannel(io.netty.channel.Channel channel) {
        this.channel = channel;
    }

    @Override
    public SocketAddress localAddress() {
        return this.channel.localAddress();
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.channel.remoteAddress();
    }

    @Override
    public ChannelHandler writeAndFlush(Object msg) {
        ChannelFuture channelFuture = this.channel.writeAndFlush(msg);
        return new NettyChannelHandler(channelFuture);
    }

    @Override
    public ChannelHandler close() {
        return new NettyChannelHandler(this.channel.close());
    }

    @Override
    public boolean isConnected() {
        return this.channel.isActive();
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public boolean isClosed() {
        return !this.isOpen();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NettyChannel that = (NettyChannel)o;
        return !(this.channel == null ? that.channel != null : !this.channel.equals(that.channel));
    }

    public int hashCode() {
        return this.channel != null ? this.channel.hashCode() : 0;
    }
}

