/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.remoting.netty;

import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import io.netty.util.internal.logging.InternalLogLevel;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

public class NettyLogger {
    public static void setNettyLoggerFactory() {
        InternalLoggerFactory factory = InternalLoggerFactory.getDefaultFactory();
        if (factory == null || !(factory instanceof LtsLoggerFactory)) {
            InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new LtsLoggerFactory());
        }
    }

    static class LtsLogger
    implements InternalLogger {
        private Logger logger;
        private String name;

        LtsLogger(String name) {
            this.name = name;
            this.logger = LoggerFactory.getLogger(name);
        }

        public String name() {
            return this.name;
        }

        public boolean isTraceEnabled() {
            return this.logger.isTraceEnabled();
        }

        public void trace(String msg) {
            this.logger.trace(msg);
        }

        public void trace(String format, Object arg) {
            this.logger.trace(format, arg);
        }

        public void trace(String format, Object argA, Object argB) {
            this.logger.trace(format, argA, argB);
        }

        public void trace(String format, Object ... arguments) {
            this.logger.trace(format, arguments);
        }

        public void trace(String msg, Throwable t) {
            this.logger.trace(msg, t);
        }

        public boolean isDebugEnabled() {
            return this.logger.isDebugEnabled();
        }

        public void debug(String msg) {
            this.logger.debug(msg);
        }

        public void debug(String format, Object arg) {
            this.logger.debug(format, arg);
        }

        public void debug(String format, Object argA, Object argB) {
            this.logger.debug(format, argA, argB);
        }

        public void debug(String format, Object ... arguments) {
            this.logger.debug(format, arguments);
        }

        public void debug(String msg, Throwable t) {
            this.logger.debug(msg, t);
        }

        public boolean isInfoEnabled() {
            return this.logger.isInfoEnabled();
        }

        public void info(String msg) {
            this.logger.info(msg);
        }

        public void info(String format, Object arg) {
            this.logger.info(format, arg);
        }

        public void info(String format, Object argA, Object argB) {
            this.logger.info(format, argA, argB);
        }

        public void info(String format, Object ... arguments) {
            this.logger.info(format, arguments);
        }

        public void info(String msg, Throwable t) {
            this.logger.info(msg, t);
        }

        public boolean isWarnEnabled() {
            return this.logger.isWarnEnabled();
        }

        public void warn(String msg) {
            this.logger.warn(msg);
        }

        public void warn(String format, Object arg) {
            this.logger.warn(format, arg);
        }

        public void warn(String format, Object ... arguments) {
            this.logger.warn(format, arguments);
        }

        public void warn(String format, Object argA, Object argB) {
            this.logger.warn(format, argA, argB);
        }

        public void warn(String msg, Throwable t) {
            this.logger.warn(msg, t);
        }

        public boolean isErrorEnabled() {
            return this.logger.isErrorEnabled();
        }

        public void error(String msg) {
            this.logger.error(msg);
        }

        public void error(String format, Object arg) {
            this.logger.error(format, arg);
        }

        public void error(String format, Object argA, Object argB) {
            this.logger.error(format, argA, argB);
        }

        public void error(String format, Object ... arguments) {
            this.logger.error(format, arguments);
        }

        public void error(String msg, Throwable t) {
            this.logger.error(msg, t);
        }

        public boolean isEnabled(InternalLogLevel level) {
            if (level == null) {
                return false;
            }
            switch (level) {
                case TRACE: {
                    return this.logger.isTraceEnabled();
                }
                case DEBUG: {
                    return this.logger.isDebugEnabled();
                }
                case INFO: {
                    return this.logger.isInfoEnabled();
                }
                case WARN: {
                    return this.logger.isWarnEnabled();
                }
                case ERROR: {
                    return this.logger.isErrorEnabled();
                }
            }
            return false;
        }

        public void log(InternalLogLevel level, String msg) {
            if (level == null) {
                return;
            }
            switch (level) {
                case TRACE: {
                    this.trace(msg);
                    break;
                }
                case DEBUG: {
                    this.debug(msg);
                    break;
                }
                case INFO: {
                    this.info(msg);
                    break;
                }
                case WARN: {
                    this.warn(msg);
                    break;
                }
                case ERROR: {
                    this.error(msg);
                }
            }
        }

        public void log(InternalLogLevel level, String format, Object arg) {
            if (level == null) {
                return;
            }
            switch (level) {
                case TRACE: {
                    this.trace(format, arg);
                    break;
                }
                case DEBUG: {
                    this.debug(format, arg);
                    break;
                }
                case INFO: {
                    this.info(format, arg);
                    break;
                }
                case WARN: {
                    this.warn(format, arg);
                    break;
                }
                case ERROR: {
                    this.error(format, arg);
                }
            }
        }

        public void log(InternalLogLevel level, String format, Object argA, Object argB) {
            if (level == null) {
                return;
            }
            switch (level) {
                case TRACE: {
                    this.trace(format, argA, argB);
                    break;
                }
                case DEBUG: {
                    this.debug(format, argA, argB);
                    break;
                }
                case INFO: {
                    this.info(format, argA, argB);
                    break;
                }
                case WARN: {
                    this.warn(format, argA, argB);
                    break;
                }
                case ERROR: {
                    this.error(format, argA, argB);
                }
            }
        }

        public void log(InternalLogLevel level, String format, Object ... arguments) {
            if (level == null) {
                return;
            }
            switch (level) {
                case TRACE: {
                    this.trace(format, arguments);
                    break;
                }
                case DEBUG: {
                    this.debug(format, arguments);
                    break;
                }
                case INFO: {
                    this.info(format, arguments);
                    break;
                }
                case WARN: {
                    this.warn(format, arguments);
                    break;
                }
                case ERROR: {
                    this.error(format, arguments);
                }
            }
        }

        public void log(InternalLogLevel level, String msg, Throwable t) {
            if (level == null) {
                return;
            }
            switch (level) {
                case TRACE: {
                    this.trace(msg, t);
                    break;
                }
                case DEBUG: {
                    this.debug(msg, t);
                    break;
                }
                case INFO: {
                    this.info(msg, t);
                    break;
                }
                case WARN: {
                    this.warn(msg, t);
                    break;
                }
                case ERROR: {
                    this.error(msg, t);
                }
            }
        }
    }

    private static class LtsLoggerFactory
    extends InternalLoggerFactory {
        private LtsLoggerFactory() {
        }

        protected InternalLogger newInstance(String name) {
            return new LtsLogger(name);
        }
    }
}

