/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.remoting.protocol;

import com.github.ltsopensource.remoting.protocol.RemotingCommand;
import com.github.ltsopensource.remoting.protocol.RemotingCommandType;

public class RemotingCommandHelper {
    private static final int RPC_TYPE = 0;
    private static final int RPC_ONEWAY = 1;

    public static void markResponseType(RemotingCommand remotingCommand) {
        int bits = 1;
        remotingCommand.setFlag(remotingCommand.getFlag() | bits);
    }

    public static boolean isResponseType(RemotingCommand remotingCommand) {
        int bits = 1;
        return (remotingCommand.getFlag() & bits) == bits;
    }

    public static void markOnewayRPC(RemotingCommand remotingCommand) {
        int bits = 2;
        remotingCommand.setFlag(remotingCommand.getFlag() | bits);
    }

    public static boolean isOnewayRPC(RemotingCommand remotingCommand) {
        int bits = 2;
        return (remotingCommand.getFlag() & bits) == bits;
    }

    public static RemotingCommandType getRemotingCommandType(RemotingCommand remotingCommand) {
        if (RemotingCommandHelper.isResponseType(remotingCommand)) {
            return RemotingCommandType.RESPONSE_COMMAND;
        }
        return RemotingCommandType.REQUEST_COMMAND;
    }
}

