/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.store.jdbc.builder;

import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.store.jdbc.SQLFormatter;
import com.github.ltsopensource.store.jdbc.SqlTemplate;
import com.github.ltsopensource.store.jdbc.exception.DupEntryException;
import com.github.ltsopensource.store.jdbc.exception.JdbcException;
import com.github.ltsopensource.store.jdbc.exception.TableNotExistException;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;

public class InsertSql {
    private static final Logger LOGGER = LoggerFactory.getLogger(InsertSql.class);
    private SqlTemplate sqlTemplate;
    private StringBuilder sql = new StringBuilder();
    private List<Object[]> params = new LinkedList<Object[]>();
    private int columnsSize = 0;

    public InsertSql(SqlTemplate sqlTemplate) {
        this.sqlTemplate = sqlTemplate;
    }

    public InsertSql insert(String table) {
        this.sql.append("INSERT INTO ");
        this.sql.append("`").append(table).append("`");
        return this;
    }

    public InsertSql insertIgnore(String table) {
        this.sql.append("INSERT IGNORE INTO ");
        this.sql.append("`").append(table).append("`");
        return this;
    }

    public InsertSql columns(String ... columns) {
        if (columns == null || columns.length == 0) {
            throw new JdbcException("columns must have length");
        }
        if (this.columnsSize > 0) {
            throw new JdbcException("columns already set");
        }
        this.columnsSize = columns.length;
        this.sql.append("(");
        String split = "";
        for (String column : columns) {
            this.sql.append(split);
            split = ", ";
            this.sql.append("`").append(column.trim()).append("`");
        }
        this.sql.append(") VALUES ");
        this.sql.append("(");
        split = "";
        for (int i = 0; i < this.columnsSize; ++i) {
            this.sql.append(split);
            split = ",";
            this.sql.append("?");
        }
        this.sql.append(")");
        return this;
    }

    public InsertSql values(Object ... values) {
        if (values == null || values.length != this.columnsSize) {
            throw new JdbcException("values.length must eq columns.length");
        }
        this.params.add(values);
        return this;
    }

    public int doInsert() {
        if (this.params.size() == 0) {
            throw new JdbcException("No values");
        }
        if (this.params.size() > 1) {
            throw new JdbcException("values.length gt 1, please use doBatchInsert");
        }
        String execSql = this.sql.toString();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(execSql);
        }
        try {
            return this.sqlTemplate.insert(execSql, this.params.get(0));
        }
        catch (SQLException e) {
            if (e.getMessage().contains("Duplicate entry")) {
                throw new DupEntryException("Insert SQL Error:" + execSql, e);
            }
            if (e.getMessage().contains("doesn't exist Query:")) {
                throw new TableNotExistException("Insert SQL Error:" + execSql, e);
            }
            throw new JdbcException("Insert SQL Error:" + execSql, e);
        }
        catch (Exception e) {
            throw new JdbcException("Insert SQL Error:" + execSql, e);
        }
    }

    public int[] doBatchInsert() {
        if (this.params.size() == 0) {
            throw new JdbcException("No values");
        }
        String finalSQL = this.sql.toString();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(SQLFormatter.format(finalSQL));
        }
        try {
            Object[][] objects = new Object[this.params.size()][this.columnsSize];
            for (int i = 0; i < this.params.size(); ++i) {
                objects[i] = this.params.get(i);
            }
            return this.sqlTemplate.batchInsert(finalSQL, objects);
        }
        catch (SQLException e) {
            if (e.getMessage().contains("Duplicate entry")) {
                throw new DupEntryException("Insert SQL Error:" + SQLFormatter.format(finalSQL), e);
            }
            if (e.getMessage().contains("doesn't exist Query:")) {
                throw new TableNotExistException("Insert SQL Error:" + SQLFormatter.format(finalSQL), e);
            }
            throw new JdbcException("Insert SQL Error:" + SQLFormatter.format(finalSQL), e);
        }
        catch (Exception e) {
            throw new JdbcException("Insert SQL Error:" + SQLFormatter.format(finalSQL), e);
        }
    }

    public String getSQL() {
        return this.sql.toString();
    }
}

