/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.store.jdbc.builder;

import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.store.jdbc.SQLFormatter;
import com.github.ltsopensource.store.jdbc.SqlTemplate;
import com.github.ltsopensource.store.jdbc.builder.WhereSql;
import com.github.ltsopensource.store.jdbc.exception.JdbcException;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;

public class UpdateSql {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdateSql.class);
    private SqlTemplate sqlTemplate;
    private StringBuilder sql = new StringBuilder();
    private List<Object> params = new LinkedList<Object>();

    public UpdateSql(SqlTemplate sqlTemplate) {
        this.sqlTemplate = sqlTemplate;
    }

    public UpdateSql update() {
        this.sql.append("UPDATE ");
        return this;
    }

    public UpdateSql table(String table) {
        this.sql.append(" `").append(table).append("` ");
        return this;
    }

    public UpdateSql set(String column, Object value) {
        if (this.params.size() > 0) {
            this.sql.append(",");
        } else {
            this.sql.append(" SET ");
        }
        this.sql.append("`").append(column).append("`").append(" = ? ");
        this.params.add(value);
        return this;
    }

    public UpdateSql setOnNotNull(String column, Object value) {
        if (value == null) {
            return this;
        }
        return this.set(column, value);
    }

    public UpdateSql where() {
        this.sql.append(" WHERE ");
        return this;
    }

    public UpdateSql whereSql(WhereSql whereSql) {
        this.sql.append(whereSql.getSQL());
        this.params.addAll(whereSql.params());
        return this;
    }

    public UpdateSql where(String condition, Object value) {
        this.sql.append(" WHERE ").append(condition);
        this.params.add(value);
        return this;
    }

    public UpdateSql and(String condition, Object value) {
        this.sql.append(" AND ").append(condition);
        this.params.add(value);
        return this;
    }

    public UpdateSql or(String condition, Object value) {
        this.sql.append(" OR ").append(condition);
        this.params.add(value);
        return this;
    }

    public UpdateSql and(String condition) {
        this.sql.append(" AND ").append(condition);
        return this;
    }

    public UpdateSql or(String condition) {
        this.sql.append(" OR ").append(condition);
        return this;
    }

    public UpdateSql andOnNotNull(String condition, Object value) {
        if (value == null) {
            return this;
        }
        return this.and(condition, value);
    }

    public UpdateSql orOnNotNull(String condition, Object value) {
        if (value == null) {
            return this;
        }
        return this.or(condition, value);
    }

    public UpdateSql andOnNotEmpty(String condition, String value) {
        if (StringUtils.isEmpty(value)) {
            return this;
        }
        return this.and(condition, value);
    }

    public UpdateSql orOnNotEmpty(String condition, String value) {
        if (StringUtils.isEmpty(value)) {
            return this;
        }
        return this.or(condition, value);
    }

    public UpdateSql andBetween(String column, Object start, Object end) {
        if (start == null && end == null) {
            return this;
        }
        if (start != null && end != null) {
            this.sql.append(" ADN (").append(column).append(" BETWEEN ? AND ? ").append(")");
            this.params.add(start);
            this.params.add(end);
            return this;
        }
        if (start == null) {
            this.sql.append(column).append(" <= ? ");
            this.params.add(end);
            return this;
        }
        this.sql.append(column).append(" >= ? ");
        this.params.add(start);
        return this;
    }

    public UpdateSql orBetween(String column, Object start, Object end) {
        if (start == null && end == null) {
            return this;
        }
        if (start != null && end != null) {
            this.sql.append(" OR (").append(column).append(" BETWEEN ? AND ? ").append(")");
            this.params.add(start);
            this.params.add(end);
            return this;
        }
        if (start == null) {
            this.sql.append(column).append(" <= ? ");
            this.params.add(end);
            return this;
        }
        this.sql.append(column).append(" >= ? ");
        this.params.add(start);
        return this;
    }

    public int doUpdate() {
        String finalSQL = this.getSQL();
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(SQLFormatter.format(finalSQL));
            }
            return this.sqlTemplate.update(finalSQL, this.params.toArray());
        }
        catch (SQLException e) {
            throw new JdbcException("Update SQL Error:" + SQLFormatter.format(finalSQL), e);
        }
    }

    public String getSQL() {
        return this.sql.toString();
    }
}

