/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.store.mongo;

import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.WriteResult;
import org.mongodb.morphia.AdvancedDatastore;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.Key;
import org.mongodb.morphia.query.Query;
import org.mongodb.morphia.query.QueryImpl;
import org.mongodb.morphia.query.UpdateOperations;
import org.mongodb.morphia.query.UpdateResults;

public class MongoTemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoTemplate.class);
    private AdvancedDatastore ds;
    private String defaultCollName;

    public MongoTemplate(AdvancedDatastore ds) {
        this.ds = ds;
    }

    private String getCollName(String collName) {
        if (StringUtils.isNotEmpty(collName)) {
            return collName;
        }
        if (StringUtils.isNotEmpty(this.getDefaultCollName())) {
            return this.getDefaultCollName();
        }
        throw new IllegalArgumentException("collName can not be null!");
    }

    public <T> Query<T> createQuery(String collName, Class<T> clazz) {
        DBCollection dbCollection = this.ds.getDB().getCollection(this.getCollName(collName));
        return new QueryImpl(clazz, dbCollection, (Datastore)this.ds);
    }

    public <T> Query<T> createQuery(Class<T> clazz) {
        return this.createQuery(null, clazz);
    }

    public <T> Key<T> save(String collName, T entity) {
        return this.ds.save(this.getCollName(collName), entity);
    }

    public <T> Key<T> save(T entity) {
        return this.save(null, entity);
    }

    public DBCollection getCollection(String collName) {
        return this.ds.getDB().getCollection(this.getCollName(collName));
    }

    public DBCollection getCollection() {
        return this.getCollection(null);
    }

    public void ensureIndex(String collName, String name, String fields) {
        this.ensureIndex(collName, name, fields, false, false);
    }

    public void ensureIndex(String name, String fields) {
        this.ensureIndex(null, name, fields);
    }

    public void ensureIndex(String name, String fields, boolean unique, boolean dropDupsOnCreate) {
        this.ensureIndex(null, name, fields, unique, dropDupsOnCreate);
    }

    public void ensureIndex(String collName, String name, String fields, boolean unique, boolean dropDupsOnCreate) {
        BasicDBObject dbFields = this.parseFieldsString(fields);
        BasicDBObjectBuilder keyOpts = new BasicDBObjectBuilder();
        if (name != null && name.length() != 0) {
            keyOpts.add("name", (Object)name);
        }
        if (unique) {
            keyOpts.add("unique", (Object)true);
            if (dropDupsOnCreate) {
                keyOpts.add("dropDups", (Object)true);
            }
        }
        DBCollection dbColl = this.getCollection(this.getCollName(collName));
        BasicDBObject opts = (BasicDBObject)keyOpts.get();
        if (opts.isEmpty()) {
            LOGGER.debug("Ensuring index for " + dbColl.getName() + " with keys:" + dbFields);
            dbColl.createIndex((DBObject)dbFields);
        } else {
            LOGGER.debug("Ensuring index for " + dbColl.getName() + " with keys:" + fields + " and opts:" + opts);
            dbColl.createIndex((DBObject)dbFields, (DBObject)opts);
        }
    }

    private BasicDBObject parseFieldsString(String fields) {
        String[] parts;
        BasicDBObjectBuilder ret = BasicDBObjectBuilder.start();
        for (String s : parts = fields.split(",")) {
            s = s.trim();
            int dir = 1;
            if (s.startsWith("-")) {
                dir = -1;
                s = s.substring(1).trim();
            }
            ret = ret.add(s, (Object)dir);
        }
        return (BasicDBObject)ret.get();
    }

    public String getDefaultCollName() {
        return this.defaultCollName;
    }

    public void setDefaultCollName(String defaultCollName) {
        this.defaultCollName = defaultCollName;
    }

    public <T> UpdateOperations<T> createUpdateOperations(Class<T> clazz) {
        return this.ds.createUpdateOperations(clazz);
    }

    public <T> T findAndDelete(Query<T> query) {
        return (T)this.ds.findAndDelete(query);
    }

    public <T> T findAndModify(Query<T> query, UpdateOperations<T> ops) {
        return this.findAndModify(query, ops, false);
    }

    public <T> T findAndModify(Query<T> query, UpdateOperations<T> ops, boolean oldVersion) {
        return this.findAndModify(query, ops, oldVersion, false);
    }

    public <T> T findAndModify(Query<T> query, UpdateOperations<T> ops, boolean oldVersion, boolean createIfMissing) {
        return (T)this.ds.findAndModify(query, ops, oldVersion, createIfMissing);
    }

    public <T> WriteResult delete(Query<T> query) {
        return this.ds.delete(query);
    }

    public <T> UpdateResults update(Query<T> query, UpdateOperations<T> ops, boolean createIfMissing) {
        return this.ds.update(query, ops, createIfMissing);
    }

    public <T> UpdateResults update(Query<T> query, UpdateOperations<T> ops) {
        return this.ds.update(query, ops);
    }

    public <T> UpdateResults updateFirst(Query<T> query, UpdateOperations<T> ops, boolean createIfMissing) {
        return this.ds.updateFirst(query, ops, createIfMissing);
    }

    public <T> UpdateResults updateFirst(Query<T> query, UpdateOperations<T> ops) {
        return this.ds.updateFirst(query, ops);
    }

    public <T> long getCount(Query<T> query) {
        return this.ds.getCount(query);
    }
}

