/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.tasktracker.logger;

import com.github.ltsopensource.core.cluster.LTSConfig;
import com.github.ltsopensource.core.constant.Environment;
import com.github.ltsopensource.core.constant.Level;
import com.github.ltsopensource.core.remoting.RemotingClientDelegate;
import com.github.ltsopensource.tasktracker.domain.TaskTrackerAppContext;
import com.github.ltsopensource.tasktracker.logger.BizLogger;
import com.github.ltsopensource.tasktracker.logger.BizLoggerImpl;
import com.github.ltsopensource.tasktracker.logger.MockBizLogger;
import java.util.concurrent.ConcurrentHashMap;

public class BizLoggerFactory {
    private static final ConcurrentHashMap<String, BizLogger> BIZ_LOGGER_CONCURRENT_HASH_MAP = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BizLogger getLogger(Level level, RemotingClientDelegate remotingClient, TaskTrackerAppContext appContext) {
        if (Environment.UNIT_TEST == LTSConfig.getEnvironment()) {
            return new MockBizLogger(level);
        }
        String key = appContext.getConfig().getIdentity();
        BizLogger logger = BIZ_LOGGER_CONCURRENT_HASH_MAP.get(key);
        if (logger == null) {
            ConcurrentHashMap<String, BizLogger> concurrentHashMap = BIZ_LOGGER_CONCURRENT_HASH_MAP;
            synchronized (concurrentHashMap) {
                logger = BIZ_LOGGER_CONCURRENT_HASH_MAP.get(key);
                if (logger != null) {
                    return logger;
                }
                logger = new BizLoggerImpl(level, remotingClient, appContext);
                BIZ_LOGGER_CONCURRENT_HASH_MAP.put(key, logger);
            }
        }
        return logger;
    }
}

