/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.tasktracker.processor;

import com.github.ltsopensource.core.protocol.JobProtos;
import com.github.ltsopensource.remoting.Channel;
import com.github.ltsopensource.remoting.RemotingProcessor;
import com.github.ltsopensource.remoting.exception.RemotingCommandException;
import com.github.ltsopensource.remoting.protocol.RemotingCommand;
import com.github.ltsopensource.remoting.protocol.RemotingProtos;
import com.github.ltsopensource.tasktracker.domain.TaskTrackerAppContext;
import com.github.ltsopensource.tasktracker.processor.AbstractProcessor;
import com.github.ltsopensource.tasktracker.processor.JobAskProcessor;
import com.github.ltsopensource.tasktracker.processor.JobPushProcessor;
import java.util.HashMap;
import java.util.Map;

public class RemotingDispatcher
extends AbstractProcessor {
    private final Map<JobProtos.RequestCode, RemotingProcessor> processors = new HashMap<JobProtos.RequestCode, RemotingProcessor>();

    public RemotingDispatcher(TaskTrackerAppContext appContext) {
        super(appContext);
        this.processors.put(JobProtos.RequestCode.PUSH_JOB, new JobPushProcessor(appContext));
        this.processors.put(JobProtos.RequestCode.JOB_ASK, new JobAskProcessor(appContext));
    }

    public RemotingCommand processRequest(Channel channel, RemotingCommand request) throws RemotingCommandException {
        JobProtos.RequestCode code = JobProtos.RequestCode.valueOf((int)request.getCode());
        RemotingProcessor processor = this.processors.get(code);
        if (processor == null) {
            return RemotingCommand.createResponseCommand((int)RemotingProtos.ResponseCode.REQUEST_CODE_NOT_SUPPORTED.code(), (String)"request code not supported!");
        }
        return processor.processRequest(channel, request);
    }
}

