/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.tasktracker;

import com.github.ltsopensource.autoconfigure.PropertiesConfigurationFactory;
import com.github.ltsopensource.core.cluster.AbstractNodeBuilder;
import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.core.properties.TaskTrackerProperties;
import com.github.ltsopensource.tasktracker.TaskTracker;
import java.util.Map;

public class TaskTrackerBuilder
extends AbstractNodeBuilder<TaskTracker, TaskTrackerBuilder> {
    protected TaskTracker build0() {
        TaskTrackerProperties properties = (TaskTrackerProperties)PropertiesConfigurationFactory.createPropertiesConfiguration(TaskTrackerProperties.class, (String[])this.locations);
        return TaskTrackerBuilder.buildByProperties(properties);
    }

    public static TaskTracker buildByProperties(TaskTrackerProperties properties) {
        TaskTracker taskTracker = new TaskTracker();
        taskTracker.setRegistryAddress(properties.getRegistryAddress());
        if (StringUtils.isNotEmpty((String[])new String[]{properties.getClusterName()})) {
            taskTracker.setClusterName(properties.getClusterName());
        }
        if (StringUtils.isNotEmpty((String[])new String[]{properties.getIdentity()})) {
            taskTracker.setIdentity(properties.getIdentity());
        }
        if (StringUtils.isNotEmpty((String[])new String[]{properties.getNodeGroup()})) {
            taskTracker.setNodeGroup(properties.getNodeGroup());
        }
        if (StringUtils.isNotEmpty((String[])new String[]{properties.getDataPath()})) {
            taskTracker.setDataPath(properties.getDataPath());
        }
        if (StringUtils.isNotEmpty((String[])new String[]{properties.getBindIp()})) {
            taskTracker.setBindIp(properties.getBindIp());
        }
        if (CollectionUtils.isNotEmpty((Map)properties.getConfigs())) {
            for (Map.Entry entry : properties.getConfigs().entrySet()) {
                taskTracker.addConfig((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (properties.getBizLoggerLevel() != null) {
            taskTracker.setBizLoggerLevel(properties.getBizLoggerLevel());
        }
        if (properties.getWorkThreads() != 0) {
            taskTracker.setWorkThreads(properties.getWorkThreads());
        }
        if (properties.getJobRunnerClass() != null) {
            taskTracker.setJobRunnerClass(properties.getJobRunnerClass());
        }
        return taskTracker;
    }
}

