/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.tasktracker.runner;

import com.github.ltsopensource.core.domain.JobMeta;
import com.github.ltsopensource.core.factory.NamedThreadFactory;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.ec.EventInfo;
import com.github.ltsopensource.ec.EventSubscriber;
import com.github.ltsopensource.ec.Observer;
import com.github.ltsopensource.tasktracker.domain.TaskTrackerAppContext;
import com.github.ltsopensource.tasktracker.expcetion.NoAvailableJobRunnerException;
import com.github.ltsopensource.tasktracker.runner.DefaultRunnerFactory;
import com.github.ltsopensource.tasktracker.runner.JobRunnerDelegate;
import com.github.ltsopensource.tasktracker.runner.RunnerCallback;
import com.github.ltsopensource.tasktracker.runner.RunnerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class RunnerPool {
    private final Logger LOGGER = LoggerFactory.getLogger(RunnerPool.class);
    private ThreadPoolExecutor threadPoolExecutor = null;
    private RunnerFactory runnerFactory;
    private TaskTrackerAppContext appContext;
    private RunningJobManager runningJobManager;

    public RunnerPool(final TaskTrackerAppContext appContext) {
        this.appContext = appContext;
        this.runningJobManager = new RunningJobManager();
        this.threadPoolExecutor = this.initThreadPoolExecutor();
        this.runnerFactory = appContext.getRunnerFactory();
        if (this.runnerFactory == null) {
            this.runnerFactory = new DefaultRunnerFactory(appContext);
        }
        appContext.getEventCenter().subscribe(new EventSubscriber(appContext.getConfig().getIdentity(), new Observer(){

            public void onObserved(EventInfo eventInfo) {
                RunnerPool.this.setWorkThread(appContext.getConfig().getWorkThreads());
            }
        }), new String[]{"WORK_THREAD_CHANGE"});
    }

    private ThreadPoolExecutor initThreadPoolExecutor() {
        int workThreads = this.appContext.getConfig().getWorkThreads();
        return new ThreadPoolExecutor(workThreads, workThreads, 30L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("JobRunnerPool"), new ThreadPoolExecutor.AbortPolicy());
    }

    public void execute(JobMeta jobMeta, RunnerCallback callback) throws NoAvailableJobRunnerException {
        try {
            this.threadPoolExecutor.execute(new JobRunnerDelegate(this.appContext, jobMeta, callback));
            if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug("Receive job success ! " + jobMeta);
            }
        }
        catch (RejectedExecutionException e) {
            this.LOGGER.warn("No more thread to run job .");
            throw new NoAvailableJobRunnerException(e);
        }
    }

    public int getAvailablePoolSize() {
        return this.threadPoolExecutor.getMaximumPoolSize() - this.threadPoolExecutor.getActiveCount();
    }

    public void setWorkThread(int workThread) {
        if (workThread == 0) {
            throw new IllegalArgumentException("workThread can not be zero!");
        }
        this.threadPoolExecutor.setMaximumPoolSize(workThread);
        this.threadPoolExecutor.setCorePoolSize(workThread);
        this.LOGGER.info("workThread update to {}", new Object[]{workThread});
    }

    public int getWorkThread() {
        return this.threadPoolExecutor.getCorePoolSize();
    }

    public RunnerFactory getRunnerFactory() {
        return this.runnerFactory;
    }

    public void stopWorking() {
        try {
            this.threadPoolExecutor.shutdownNow();
            Thread.sleep(1000L);
            this.threadPoolExecutor = this.initThreadPoolExecutor();
            this.LOGGER.info("stop working succeed ");
        }
        catch (Throwable t) {
            this.LOGGER.error("stop working failed ", t);
        }
    }

    public void shutDown() {
        try {
            this.threadPoolExecutor.shutdownNow();
            this.LOGGER.info("stop working succeed ");
        }
        catch (Throwable t) {
            this.LOGGER.error("stop working failed ", t);
        }
    }

    public RunningJobManager getRunningJobManager() {
        return this.runningJobManager;
    }

    public class RunningJobManager {
        private final ConcurrentMap<String, JobRunnerDelegate> JOBS = new ConcurrentHashMap<String, JobRunnerDelegate>();

        public void in(String jobId, JobRunnerDelegate jobRunnerDelegate) {
            this.JOBS.putIfAbsent(jobId, jobRunnerDelegate);
        }

        public void out(String jobId) {
            this.JOBS.remove(jobId);
        }

        public boolean running(String jobId) {
            return this.JOBS.containsKey(jobId);
        }

        public List<String> getNotExists(List<String> jobIds) {
            if (RunnerPool.this.LOGGER.isDebugEnabled()) {
                RunnerPool.this.LOGGER.debug("Ask jobs: " + jobIds + " Running jobs \uff1a" + this.JOBS.keySet());
            }
            ArrayList<String> notExistList = new ArrayList<String>();
            for (String jobId : jobIds) {
                if (this.running(jobId)) continue;
                notExistList.add(jobId);
            }
            return notExistList;
        }

        public void terminateJob(String jobId) {
            JobRunnerDelegate jobRunnerDelegate = (JobRunnerDelegate)this.JOBS.get(jobId);
            if (jobRunnerDelegate != null) {
                try {
                    jobRunnerDelegate.currentThread().interrupt();
                }
                catch (Throwable e) {
                    RunnerPool.this.LOGGER.error("terminateJob [" + jobId + "]  error", e);
                }
            }
        }
    }
}

