/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikereem.apple.signin.util;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.mikereem.apple.signin.model.Header;
import com.github.mikereem.apple.signin.model.TokenResponse;
import com.github.mikereem.apple.signin.model.User;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.IOException;
import java.io.Reader;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;

public class AppleSigninUtil {
    private static final Logger LOGGER = Logger.getLogger(AppleSigninUtil.class);
    private static String APPLE_APPLEID_URL = "https://appleid.apple.com";
    private static String APPLE_AUTH_URL = "https://appleid.apple.com/auth/token";
    private static String APPLE_PUBLIC_KEY_URL = "https://appleid.apple.com/auth/keys";
    private static ObjectMapper objectMapper = new ObjectMapper();
    private static String keyId;
    private static String teamId;
    private static PrivateKey privateKey;
    private static Map<String, PublicKey> publicKeys;

    public static void init(String keyId, String teamId, Reader privateKeyReader) throws IOException {
        AppleSigninUtil.keyId = keyId;
        AppleSigninUtil.teamId = teamId;
        privateKey = AppleSigninUtil.getPrivateKey(privateKeyReader);
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    private static PrivateKey getPrivateKey(Reader privateKeyReader) throws IOException {
        PEMParser pemParser = new PEMParser(privateKeyReader);
        JcaPEMKeyConverter pemKeyConverter = new JcaPEMKeyConverter();
        PrivateKeyInfo keyInfo = (PrivateKeyInfo)pemParser.readObject();
        PrivateKey key = pemKeyConverter.getPrivateKey(keyInfo);
        pemParser.close();
        return key;
    }

    private static PublicKey getPublicKey(Header header) {
        PublicKey publicKey = null;
        try {
            if (publicKeys == null || publicKeys.size() == 0) {
                String publicKeyResult = AppleSigninUtil.get(APPLE_PUBLIC_KEY_URL);
                if (publicKeyResult == null || publicKeyResult.length() == 0) {
                    return null;
                }
                publicKeys = new HashMap<String, PublicKey>();
                Map maps = (Map)objectMapper.readValue(publicKeyResult, Map.class);
                List keys = (List)maps.get("keys");
                for (Map key : keys) {
                    if (key == null) continue;
                    Base64.decodeBase64((String)key.get("n").toString());
                    byte[] nBytes = Base64.decodeBase64((String)key.get("n").toString());
                    byte[] eBytes = Base64.decodeBase64((String)key.get("e").toString());
                    BigInteger modulus = new BigInteger(1, nBytes);
                    BigInteger publicExponent = new BigInteger(1, eBytes);
                    RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(modulus, publicExponent);
                    String algorithm = key.get("kty").toString();
                    KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
                    publicKey = keyFactory.generatePublic(publicKeySpec);
                    String mapKey = String.format("%s_%s", key.get("kid"), key.get("alg"));
                    publicKeys.put(mapKey, publicKey);
                }
            }
            String headerKey = String.format("%s_%s", header.getKid(), header.getAlg());
            publicKey = publicKeys.get(headerKey);
        }
        catch (Throwable t) {
            LOGGER.error((Object)("Error during getting apple public key. Reason:" + t.getMessage()), t);
        }
        return publicKey;
    }

    private static String getToken(String clientId) {
        String token = Jwts.builder().setHeaderParam("kid", (Object)keyId).setIssuer(teamId).setAudience(APPLE_APPLEID_URL).setSubject(clientId).setExpiration(new Date(System.currentTimeMillis() + 300000L)).setIssuedAt(new Date(System.currentTimeMillis())).signWith((Key)privateKey, SignatureAlgorithm.ES256).compact();
        return token;
    }

    public static Claims authorize(String clientId, String identityToken, String code, String redirectURI) throws JsonParseException, JsonMappingException, IOException {
        LOGGER.info((Object)"Apple authorization validation");
        String clientSubject = AppleSigninUtil.getSubject(identityToken);
        String token = AppleSigninUtil.getToken(clientId);
        LOGGER.debug((Object)("Authorize with token:" + token));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("client_id", clientId);
        params.put("client_secret", token);
        params.put("code", code);
        params.put("grant_type", "authorization_code");
        if (redirectURI != null) {
            params.put("redirect_uri", redirectURI);
        }
        String response = AppleSigninUtil.post(APPLE_AUTH_URL, params);
        LOGGER.info((Object)("Apple authorization response:" + response));
        TokenResponse tokenResponse = (TokenResponse)objectMapper.readValue(response, TokenResponse.class);
        if (tokenResponse.getError() != null && tokenResponse.getError().length() > 0) {
            LOGGER.warn((Object)("Error during verification of the code. Reason:" + tokenResponse.getError()));
            return null;
        }
        String serverSubject = AppleSigninUtil.getSubject(tokenResponse.getId_token());
        if (!serverSubject.equals(clientSubject)) {
            LOGGER.warn((Object)"Validation failed, subject does not match!");
            return null;
        }
        return AppleSigninUtil.getClaims(tokenResponse.getId_token());
    }

    public static User parseUser(String userJson) throws JsonParseException, JsonMappingException, IOException {
        User user = (User)objectMapper.readValue(userJson, User.class);
        return user;
    }

    public String getEmail(Claims claims) {
        return (String)claims.get("email", String.class);
    }

    public String getSubject(Claims claims) {
        return (String)claims.get("sub", String.class);
    }

    public Boolean isPrivateEmail(Claims claims) {
        return (Boolean)claims.get("is_private_email", Boolean.class);
    }

    private static String getSubject(String identityToken) {
        return AppleSigninUtil.getClaims(identityToken).getSubject();
    }

    private static Claims getClaims(String identityToken) {
        Header header = AppleSigninUtil.parseHeader(identityToken);
        PublicKey publicKey = AppleSigninUtil.getPublicKey(header);
        JwtParser jwtParser = Jwts.parser().setSigningKey((Key)publicKey);
        Jws jws = jwtParser.parseClaimsJws(identityToken);
        return (Claims)jws.getBody();
    }

    private static Header parseHeader(String identityToken) {
        Header header = null;
        try {
            String[] arrToken = identityToken.split("\\.");
            if (arrToken == null || arrToken.length != 3) {
                return null;
            }
            String text = new String(Base64.decodeBase64((String)arrToken[0]), "utf-8");
            header = (Header)objectMapper.readValue(text, Header.class);
        }
        catch (Throwable t) {
            LOGGER.warn((Object)"Unable to parse the Identity Token header.", t);
        }
        return header;
    }

    private static String get(String url) {
        String result = null;
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        Integer statusCode = null;
        String reason = null;
        try {
            httpClient = HttpClientBuilder.create().build();
            HttpGet httpGet = new HttpGet(url);
            response = httpClient.execute((HttpUriRequest)httpGet);
            statusCode = response.getStatusLine().getStatusCode();
            reason = response.getStatusLine().getReasonPhrase();
            HttpEntity entity = response.getEntity();
            result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            if (statusCode != 200) {
                LOGGER.error((Object)String.format("HTTP GET failed to URL:%s. Status code: %s. Reason:%s. Result:%s.", url, statusCode, reason, result));
            }
        }
        catch (Throwable t) {
            LOGGER.error((Object)String.format("HTTP GET failed to URL:%s. Status code: %s. Reason:%s.", url, statusCode, reason), t);
        }
        return result;
    }

    private static String post(String url, Map<String, String> params) {
        String result = null;
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        Integer statusCode = null;
        String reason = null;
        try {
            httpClient = HttpClientBuilder.create().build();
            HttpPost httpPost = new HttpPost(url);
            httpPost.addHeader("Content-Type", "application/x-www-form-urlencoded");
            ArrayList<BasicNameValuePair> nameValues = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                nameValues.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity(nameValues);
            httpPost.setEntity((HttpEntity)formEntity);
            response = httpClient.execute((HttpUriRequest)httpPost);
            statusCode = response.getStatusLine().getStatusCode();
            reason = response.getStatusLine().getReasonPhrase();
            HttpEntity entity = response.getEntity();
            result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            if (statusCode != 200) {
                LOGGER.error((Object)String.format("HTTP POST failed to URL:%s. Status code: %s. Reason:%s. Parameters:%s. Result:%s.", url, statusCode, reason, objectMapper.writeValueAsString(params), result));
            }
            EntityUtils.consume((HttpEntity)entity);
        }
        catch (Throwable t) {
            try {
                LOGGER.error((Object)String.format("HTTP POST failed to URL:%s. Status code: %s. Reason:%s. Parameters:%s.", url, statusCode, reason, objectMapper.writeValueAsString(params)));
            }
            catch (JsonProcessingException e) {
                LOGGER.error((Object)e, (Throwable)e);
            }
        }
        return result;
    }
}

