/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol;

import com.github.mizosoft.methanol.internal.spi.DecoderFactoryFinder;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;

public interface BodyDecoder<T>
extends HttpResponse.BodySubscriber<T> {
    public String encoding();

    public Optional<Executor> executor();

    public HttpResponse.BodySubscriber<T> downstream();

    @Override
    default public CompletionStage<T> getBody() {
        return this.downstream().getBody();
    }

    public static interface Factory {
        public String encoding();

        public <T> BodyDecoder<T> create(HttpResponse.BodySubscriber<T> var1);

        public <T> BodyDecoder<T> create(HttpResponse.BodySubscriber<T> var1, Executor var2);

        public static List<Factory> installedFactories() {
            return DecoderFactoryFinder.findInstalledFactories();
        }

        public static Map<String, Factory> installedBindings() {
            return DecoderFactoryFinder.getInstalledBindings();
        }

        public static Optional<Factory> getFactory(String encoding) {
            Objects.requireNonNull(encoding);
            return Optional.ofNullable(Factory.installedBindings().get(encoding));
        }
    }
}

