/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol;

import com.github.mizosoft.methanol.MediaType;
import com.github.mizosoft.methanol.MimeBodyPublisher;
import java.net.URLEncoder;
import java.net.http.HttpRequest;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.Flow;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public final class FormBodyPublisher
implements MimeBodyPublisher {
    private final Map<String, List<String>> queries;
    private @MonotonicNonNull String encodedString;

    private FormBodyPublisher(Map<String, List<String>> queries) {
        this.queries = queries;
    }

    public String encodedString() {
        String result = this.encodedString;
        if (result == null) {
            this.encodedString = result = this.computeEncodedString();
        }
        return result;
    }

    private String computeEncodedString() {
        StringJoiner joiner = new StringJoiner("&");
        for (Map.Entry<String, List<String>> entry : this.queries.entrySet()) {
            String encodedName = FormBodyPublisher.encodeFormValueUtf8(entry.getKey());
            for (String value : entry.getValue()) {
                joiner.add(encodedName + "=" + FormBodyPublisher.encodeFormValueUtf8(value));
            }
        }
        return joiner.toString();
    }

    public Optional<String> firstQuery(String name) {
        List values = this.queries.getOrDefault(name, List.of());
        return values.isEmpty() ? Optional.empty() : Optional.of((String)values.get(0));
    }

    public Optional<String> lastQuery(String name) {
        List values = this.queries.getOrDefault(name, List.of());
        return values.isEmpty() ? Optional.empty() : Optional.of((String)values.get(values.size() - 1));
    }

    public Map<String, List<String>> queries() {
        return this.queries;
    }

    @Override
    public MediaType mediaType() {
        return MediaType.APPLICATION_FORM_URLENCODED;
    }

    @Override
    public long contentLength() {
        return this.encodedString().length();
    }

    @Override
    public void subscribe(Flow.Subscriber<? super ByteBuffer> subscriber) {
        Objects.requireNonNull(subscriber);
        HttpRequest.BodyPublishers.ofString(this.encodedString(), StandardCharsets.US_ASCII).subscribe(subscriber);
    }

    private static String encodeFormValueUtf8(String value) {
        return URLEncoder.encode(value, StandardCharsets.UTF_8);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, List<String>> queries = new LinkedHashMap<String, List<String>>();

        Builder() {
        }

        public Builder query(String name, String value) {
            Objects.requireNonNull(name, "name");
            Objects.requireNonNull(value, "value");
            this.queries.computeIfAbsent(name, __ -> new ArrayList()).add(value);
            return this;
        }

        public FormBodyPublisher build() {
            if (this.queries.isEmpty()) {
                return new FormBodyPublisher(Map.of());
            }
            LinkedHashMap deepCopy = new LinkedHashMap();
            this.queries.forEach((n, vs) -> deepCopy.put(n, List.copyOf(vs)));
            return new FormBodyPublisher(Collections.unmodifiableMap(deepCopy));
        }
    }
}

