/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol;

import com.github.mizosoft.methanol.BodyAdapter;
import com.github.mizosoft.methanol.MediaType;
import com.github.mizosoft.methanol.TypeRef;
import com.github.mizosoft.methanol.internal.Utils;
import com.github.mizosoft.methanol.internal.concurrent.Delayer;
import com.github.mizosoft.methanol.internal.extensions.AsyncSubscriberAdapter;
import com.github.mizosoft.methanol.internal.extensions.ByteChannelSubscriber;
import com.github.mizosoft.methanol.internal.extensions.TimeoutBodySubscriber;
import java.io.Reader;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MoreBodySubscribers {
    private MoreBodySubscribers() {
    }

    public static <T, S extends Flow.Subscriber<? super List<ByteBuffer>>> HttpResponse.BodySubscriber<T> fromAsyncSubscriber(S downstream, Function<? super S, ? extends CompletionStage<T>> asyncFinisher) {
        return new AsyncSubscriberAdapter(downstream, asyncFinisher);
    }

    public static <T> HttpResponse.BodySubscriber<T> withReadTimeout(HttpResponse.BodySubscriber<T> downstream, Duration timeout) {
        Objects.requireNonNull(downstream);
        Objects.requireNonNull(timeout);
        Utils.requirePositiveDuration(timeout);
        return new TimeoutBodySubscriber<T>(timeout, Delayer.systemDelayer(), downstream);
    }

    public static <T> HttpResponse.BodySubscriber<T> withReadTimeout(HttpResponse.BodySubscriber<T> downstream, Duration timeout, ScheduledExecutorService scheduler) {
        Objects.requireNonNull(downstream);
        Objects.requireNonNull(timeout);
        Objects.requireNonNull(scheduler);
        Utils.requirePositiveDuration(timeout);
        return new TimeoutBodySubscriber<T>(timeout, Delayer.of(scheduler), downstream);
    }

    public static HttpResponse.BodySubscriber<ReadableByteChannel> ofByteChannel() {
        return new ByteChannelSubscriber();
    }

    public static HttpResponse.BodySubscriber<Reader> ofReader(Charset charset) {
        Objects.requireNonNull(charset);
        return HttpResponse.BodySubscribers.mapping(MoreBodySubscribers.ofByteChannel(), ch -> Channels.newReader(ch, charset));
    }

    public static <T> HttpResponse.BodySubscriber<T> ofObject(TypeRef<T> type, @Nullable MediaType mediaType) {
        return MoreBodySubscribers.requireDecoder(type, mediaType).toObject(type, mediaType);
    }

    public static <T> HttpResponse.BodySubscriber<Supplier<T>> ofDeferredObject(TypeRef<T> type, @Nullable MediaType mediaType) {
        return MoreBodySubscribers.requireDecoder(type, mediaType).toDeferredObject(type, mediaType);
    }

    private static BodyAdapter.Decoder requireDecoder(TypeRef<?> type, @Nullable MediaType mediaType) {
        return BodyAdapter.Decoder.getDecoder(type, mediaType).orElseThrow(() -> MoreBodySubscribers.unsupportedConversion(type, mediaType));
    }

    private static UnsupportedOperationException unsupportedConversion(TypeRef<?> type, @Nullable MediaType mediaType) {
        String message = "unsupported conversion to an object of type <" + type + ">";
        if (mediaType != null) {
            message = message + " with media type <" + mediaType + ">";
        }
        return new UnsupportedOperationException(message);
    }
}

