/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol;

import com.github.mizosoft.methanol.CacheControl;
import com.github.mizosoft.methanol.TaggableRequest;
import com.github.mizosoft.methanol.TypeRef;
import com.github.mizosoft.methanol.internal.Utils;
import com.github.mizosoft.methanol.internal.Validate;
import com.github.mizosoft.methanol.internal.extensions.HeadersBuilder;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class MutableRequest
extends TaggableRequest
implements TaggableRequest.Builder {
    private static final URI EMPTY_URI = URI.create("");
    private final Map<TypeRef<?>, Object> tags;
    private final HeadersBuilder headersBuilder;
    private String method;
    private URI uri;
    private @Nullable HttpHeaders cachedHeaders;
    private @Nullable HttpRequest.BodyPublisher bodyPublisher;
    private @MonotonicNonNull Duration timeout;
    private  @MonotonicNonNull HttpClient.Version version;
    private boolean expectContinue;

    private MutableRequest() {
        this.tags = new HashMap();
        this.headersBuilder = new HeadersBuilder();
        this.method = "GET";
        this.uri = EMPTY_URI;
    }

    private MutableRequest(MutableRequest other) {
        this.tags = new HashMap(other.tags);
        this.headersBuilder = other.headersBuilder.deepCopy();
        this.method = other.method;
        this.uri = other.uri;
        this.cachedHeaders = other.cachedHeaders;
        this.bodyPublisher = other.bodyPublisher;
        this.expectContinue = other.expectContinue;
        if (other.timeout != null) {
            this.timeout = other.timeout;
        }
        if (other.version != null) {
            this.version = other.version;
        }
    }

    public MutableRequest uri(String uri) {
        Objects.requireNonNull(uri);
        return this.uri(URI.create(uri));
    }

    public MutableRequest removeHeaders() {
        this.cachedHeaders = null;
        this.headersBuilder.clear();
        return this;
    }

    public MutableRequest removeHeader(String name) {
        Objects.requireNonNull(name);
        if (this.headersBuilder.remove(name)) {
            this.cachedHeaders = null;
        }
        return this;
    }

    public MutableRequest removeHeadersIf(BiPredicate<String, String> filter) {
        Objects.requireNonNull(filter);
        if (this.headersBuilder.removeIf(filter)) {
            this.cachedHeaders = null;
        }
        return this;
    }

    public MutableRequest headers(HttpHeaders headers) {
        Objects.requireNonNull(headers);
        this.cachedHeaders = null;
        for (Map.Entry<String, List<String>> entry : headers.map().entrySet()) {
            String name = entry.getKey();
            Utils.validateHeaderName(name);
            for (String value : entry.getValue()) {
                Utils.validateHeaderValue(value);
                this.headersBuilder.add(name, value);
            }
        }
        return this;
    }

    public MutableRequest cacheControl(CacheControl cacheControl) {
        Objects.requireNonNull(cacheControl);
        return this.header("Cache-Control", cacheControl.toString());
    }

    public MutableRequest apply(Consumer<? super MutableRequest> consumer) {
        Objects.requireNonNull(consumer);
        consumer.accept(this);
        return this;
    }

    @Override
    public <T> Optional<T> tag(TypeRef<T> type) {
        Objects.requireNonNull(type);
        return Optional.ofNullable(this.tags.get(type));
    }

    @Override
    Map<TypeRef<?>, Object> tags() {
        return Map.copyOf(this.tags);
    }

    @Override
    public MutableRequest tag(Object value) {
        Objects.requireNonNull(value);
        return this.tag((Class)value.getClass(), value);
    }

    @Override
    public <T> MutableRequest tag(Class<T> type, T value) {
        return this.tag((TypeRef)TypeRef.from(type), (Object)value);
    }

    @Override
    public <T> MutableRequest tag(TypeRef<T> type, T value) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(value);
        this.tags.put(type, value);
        return this;
    }

    @Override
    public MutableRequest removeTag(Class<?> type) {
        return this.removeTag((TypeRef)TypeRef.from(type));
    }

    @Override
    public MutableRequest removeTag(TypeRef<?> type) {
        Objects.requireNonNull(type);
        this.tags.remove(type);
        return this;
    }

    @Override
    public Optional<HttpRequest.BodyPublisher> bodyPublisher() {
        return Optional.ofNullable(this.bodyPublisher);
    }

    @Override
    public String method() {
        return this.method;
    }

    @Override
    public Optional<Duration> timeout() {
        return Optional.ofNullable(this.timeout);
    }

    @Override
    public boolean expectContinue() {
        return this.expectContinue;
    }

    @Override
    public URI uri() {
        return this.uri;
    }

    @Override
    public Optional<HttpClient.Version> version() {
        return Optional.ofNullable(this.version);
    }

    @Override
    public HttpHeaders headers() {
        HttpHeaders headers = this.cachedHeaders;
        if (headers == null) {
            this.cachedHeaders = headers = this.headersBuilder.build();
        }
        return headers;
    }

    @Override
    public MutableRequest uri(URI uri) {
        this.uri = Objects.requireNonNull(uri);
        return this;
    }

    @Override
    public MutableRequest expectContinue(boolean enable) {
        this.expectContinue = enable;
        return this;
    }

    @Override
    public MutableRequest version(HttpClient.Version version) {
        this.version = Objects.requireNonNull(version);
        return this;
    }

    @Override
    public MutableRequest header(String name, String value) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(value);
        Utils.validateHeader(name, value);
        this.cachedHeaders = null;
        this.headersBuilder.add(name, value);
        return this;
    }

    @Override
    public MutableRequest headers(String ... headers) {
        Objects.requireNonNull(headers, "headers");
        int len = headers.length;
        Validate.requireArgument(len > 0 && len % 2 == 0, "illegal number of headers: %d", len);
        this.cachedHeaders = null;
        for (int i = 0; i < len; i += 2) {
            String name = headers[i];
            String value = headers[i + 1];
            Objects.requireNonNull(name);
            Objects.requireNonNull(value);
            Utils.validateHeader(name, value);
            this.headersBuilder.add(name, value);
        }
        return this;
    }

    @Override
    public MutableRequest timeout(Duration timeout) {
        Objects.requireNonNull(timeout);
        Utils.requirePositiveDuration(timeout);
        this.timeout = timeout;
        return this;
    }

    @Override
    public MutableRequest setHeader(String name, String value) {
        Utils.validateHeader(name, value);
        this.cachedHeaders = null;
        this.headersBuilder.set(name, value);
        return this;
    }

    @Override
    public MutableRequest GET() {
        return this.setMethod("GET", null);
    }

    @Override
    public MutableRequest POST(HttpRequest.BodyPublisher bodyPublisher) {
        Objects.requireNonNull(bodyPublisher);
        return this.setMethod("POST", bodyPublisher);
    }

    @Override
    public MutableRequest PUT(HttpRequest.BodyPublisher bodyPublisher) {
        Objects.requireNonNull(bodyPublisher);
        return this.setMethod("PUT", bodyPublisher);
    }

    @Override
    public MutableRequest DELETE() {
        return this.setMethod("DELETE", null);
    }

    @Override
    public MutableRequest method(String method, HttpRequest.BodyPublisher bodyPublisher) {
        Objects.requireNonNull(method, "method");
        Objects.requireNonNull(bodyPublisher, "bodyPublisher");
        Validate.requireArgument(Utils.isValidToken(method), "illegal method name: '%s'", method);
        return this.setMethod(method, bodyPublisher);
    }

    @Override
    public TaggableRequest build() {
        return new ImmutableRequest(this);
    }

    public TaggableRequest toImmutableRequest() {
        return new ImmutableRequest(this);
    }

    @Override
    public MutableRequest copy() {
        return new MutableRequest(this);
    }

    public String toString() {
        return this.uri + " " + this.method;
    }

    private MutableRequest setMethod(String method, @Nullable HttpRequest.BodyPublisher bodyPublisher) {
        this.method = method;
        this.bodyPublisher = bodyPublisher;
        return this;
    }

    private static MutableRequest createCopy(HttpRequest other) {
        return new MutableRequest().uri(other.uri()).headers(other.headers()).setMethod(other.method(), other.bodyPublisher().orElse(null)).expectContinue(other.expectContinue()).apply(self -> {
            other.timeout().ifPresent(self::timeout);
            other.version().ifPresent(self::version);
            if (other instanceof TaggableRequest) {
                self.tags.putAll(((TaggableRequest)other).tags());
            }
        });
    }

    public static MutableRequest copyOf(HttpRequest other) {
        Objects.requireNonNull(other);
        return other instanceof MutableRequest ? ((MutableRequest)other).copy() : MutableRequest.createCopy(other);
    }

    public static MutableRequest create() {
        return new MutableRequest();
    }

    public static MutableRequest create(String uri) {
        return new MutableRequest().uri(uri);
    }

    public static MutableRequest create(URI uri) {
        return new MutableRequest().uri(uri);
    }

    public static MutableRequest GET(String uri) {
        return new MutableRequest().uri(uri);
    }

    public static MutableRequest GET(URI uri) {
        return new MutableRequest().uri(uri);
    }

    public static MutableRequest POST(String uri, HttpRequest.BodyPublisher bodyPublisher) {
        return new MutableRequest().uri(uri).POST(bodyPublisher);
    }

    public static MutableRequest POST(URI uri, HttpRequest.BodyPublisher bodyPublisher) {
        return new MutableRequest().uri(uri).POST(bodyPublisher);
    }

    private static final class ImmutableRequest
    extends TaggableRequest {
        private final String method;
        private final URI uri;
        private final HttpHeaders headers;
        private final Optional<HttpRequest.BodyPublisher> bodyPublisher;
        private final Optional<Duration> timeout;
        private final Optional<HttpClient.Version> version;
        private final boolean expectContinue;
        private final Map<TypeRef<?>, Object> tags;

        ImmutableRequest(MutableRequest other) {
            this.method = other.method;
            this.uri = other.uri;
            this.headers = other.headers();
            this.bodyPublisher = Optional.ofNullable(other.bodyPublisher);
            this.timeout = Optional.ofNullable(other.timeout);
            this.version = Optional.ofNullable(other.version);
            this.expectContinue = other.expectContinue;
            this.tags = Map.copyOf(other.tags);
        }

        @Override
        public <T> Optional<T> tag(TypeRef<T> type) {
            Objects.requireNonNull(type);
            return Optional.ofNullable(this.tags.get(type));
        }

        @Override
        Map<TypeRef<?>, Object> tags() {
            return this.tags;
        }

        @Override
        public String method() {
            return this.method;
        }

        @Override
        public URI uri() {
            return this.uri;
        }

        @Override
        public HttpHeaders headers() {
            return this.headers;
        }

        @Override
        public Optional<HttpRequest.BodyPublisher> bodyPublisher() {
            return this.bodyPublisher;
        }

        @Override
        public boolean expectContinue() {
            return this.expectContinue;
        }

        @Override
        public Optional<Duration> timeout() {
            return this.timeout;
        }

        @Override
        public Optional<HttpClient.Version> version() {
            return this.version;
        }

        public String toString() {
            return this.uri + " " + this.method;
        }
    }
}

