/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol.adapter;

import com.github.mizosoft.methanol.BodyAdapter;
import com.github.mizosoft.methanol.MediaType;
import com.github.mizosoft.methanol.MoreBodyPublishers;
import com.github.mizosoft.methanol.TypeRef;
import java.net.http.HttpRequest;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractBodyAdapter
implements BodyAdapter {
    private final Set<MediaType> compatibleMediaTypes;

    protected AbstractBodyAdapter(MediaType ... compatibleMediaTypes) {
        this.compatibleMediaTypes = Set.of(compatibleMediaTypes);
    }

    @Override
    public final boolean isCompatibleWith(MediaType mediaType) {
        Objects.requireNonNull(mediaType);
        return this.compatibleMediaTypes.stream().anyMatch(mediaType::isCompatibleWith);
    }

    protected Set<MediaType> compatibleMediaTypes() {
        return this.compatibleMediaTypes;
    }

    protected void requireSupport(TypeRef<?> type) {
        if (!this.supportsType(type)) {
            throw new UnsupportedOperationException("unsupported type: " + type);
        }
    }

    protected void requireSupport(Class<?> type) {
        this.requireSupport(TypeRef.from(type));
    }

    protected void requireCompatibleOrNull(@Nullable MediaType mediaType) {
        if (mediaType != null && !this.isCompatibleWith(mediaType)) {
            throw new UnsupportedOperationException("adapter not compatible with: " + mediaType);
        }
    }

    public static Charset charsetOrDefault(@Nullable MediaType mediaType, Charset defaultCharset) {
        Objects.requireNonNull(defaultCharset);
        return mediaType != null ? mediaType.charsetOrDefault(defaultCharset) : defaultCharset;
    }

    public static Charset charsetOrUtf8(@Nullable MediaType mediaType) {
        return AbstractBodyAdapter.charsetOrDefault(mediaType, StandardCharsets.UTF_8);
    }

    public static HttpRequest.BodyPublisher attachMediaType(HttpRequest.BodyPublisher publisher, @Nullable MediaType mediaType) {
        Objects.requireNonNull(publisher);
        if (mediaType != null && !mediaType.hasWildcard()) {
            return MoreBodyPublishers.ofMediaType(publisher, mediaType);
        }
        return publisher;
    }
}

