/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol.internal.cache;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.checkerframework.checker.nullness.qual.Nullable;

final class ExecutorServiceAdapter
extends AbstractExecutorService {
    private final Executor executor;
    private final Set<TrackedRunnable> queuedTasks = new HashSet<TrackedRunnable>();
    private final Set<Thread> executingThreads = new HashSet<Thread>();
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition termination = this.lock.newCondition();
    private boolean shutdown;

    ExecutorServiceAdapter(Executor executor) {
        this.executor = executor;
    }

    @Override
    public void shutdown() {
        this.lock.lock();
        try {
            this.shutdown = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.lock.lock();
        try {
            List<Runnable> dumped = List.copyOf(this.queuedTasks);
            this.queuedTasks.clear();
            this.executingThreads.forEach(Thread::interrupt);
            this.shutdown = true;
            List<Runnable> list = dumped;
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isShutdown() {
        this.lock.lock();
        try {
            boolean bl = this.shutdown;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isTerminated() {
        this.lock.lock();
        try {
            boolean bl = this.isTerminatedUnlocked();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long remaining = unit.toNanos(timeout);
        this.lock.lock();
        try {
            while (!this.isTerminatedUnlocked()) {
                if (remaining <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                remaining = this.termination.awaitNanos(remaining);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean isTerminatedUnlocked() {
        assert (this.lock.isHeldByCurrentThread());
        return this.shutdown && this.queuedTasks.isEmpty() && this.executingThreads.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable command) {
        Objects.requireNonNull(command);
        TrackedRunnable task = new TrackedRunnable(command);
        this.lock.lock();
        try {
            if (this.shutdown) {
                throw new RejectedExecutionException("ExecutorService has been shutdown");
            }
            this.queuedTasks.add(task);
        }
        finally {
            this.lock.unlock();
        }
        try {
            this.executor.execute(task);
        }
        catch (RejectedExecutionException e) {
            this.lock.lock();
            try {
                this.queuedTasks.remove(task);
            }
            finally {
                this.lock.unlock();
            }
            throw e;
        }
    }

    static ExecutorService adapt(Executor executor) {
        return executor instanceof ExecutorService ? (ExecutorService)executor : new ExecutorServiceAdapter(executor);
    }

    private final class TrackedRunnable
    implements Runnable {
        final Runnable runnable;
        @Nullable Thread executingThread;

        TrackedRunnable(Runnable runnable) {
            this.runnable = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ExecutorServiceAdapter.this.lock.lock();
            try {
                if (!ExecutorServiceAdapter.this.queuedTasks.remove(this)) {
                    return;
                }
                this.executingThread = Thread.currentThread();
                ExecutorServiceAdapter.this.executingThreads.add(this.executingThread);
            }
            finally {
                ExecutorServiceAdapter.this.lock.unlock();
            }
            try {
                this.runnable.run();
            }
            finally {
                ExecutorServiceAdapter.this.lock.lock();
                try {
                    ExecutorServiceAdapter.this.executingThreads.remove(this.executingThread);
                    this.executingThread = null;
                    if (ExecutorServiceAdapter.this.isTerminatedUnlocked()) {
                        ExecutorServiceAdapter.this.termination.signalAll();
                    }
                }
                finally {
                    ExecutorServiceAdapter.this.lock.unlock();
                }
            }
        }

        public String toString() {
            return this.runnable.toString();
        }
    }
}

