/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol.internal.cache;

import com.github.mizosoft.methanol.TrackedResponse;
import com.github.mizosoft.methanol.internal.cache.DateUtils;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Optional;

final class FreshnessPolicy {
    private final Optional<Duration> maxAge;
    private final Instant timeRequestSent;
    private final Instant timeResponseReceived;
    private final Duration age;
    private final LocalDateTime date;
    private final Optional<LocalDateTime> expires;
    private final LocalDateTime effectiveLastModified;

    FreshnessPolicy(Optional<Duration> maxAge, TrackedResponse<?> response) {
        this.timeRequestSent = response.timeRequestSent();
        this.timeResponseReceived = response.timeResponseReceived();
        this.maxAge = maxAge;
        Optional<LocalDateTime> dateServed = response.headers().firstValue("Date").map(DateUtils::toHttpDate);
        this.date = dateServed.orElseGet(() -> DateUtils.toUtcDateTime(this.timeResponseReceived));
        this.expires = response.headers().firstValue("Expires").map(DateUtils::toHttpDate);
        this.effectiveLastModified = response.headers().firstValue("Last-Modified").map(DateUtils::toHttpDate).orElse(this.date);
        this.age = response.headers().firstValue("Age").map(DateUtils::toDeltaSecondsOrNull).orElse(Duration.ZERO);
    }

    LocalDateTime effectiveLastModified() {
        return this.effectiveLastModified;
    }

    Duration computeFreshnessLifetime() {
        return this.maxAge.or(() -> this.expires.map(expires -> Duration.between(this.date, expires))).orElseGet(this::computeHeuristicFreshnessLifetime);
    }

    private Duration computeHeuristicFreshnessLifetime() {
        return Duration.between(this.effectiveLastModified, this.date).dividedBy(10L);
    }

    boolean usesHeuristics() {
        return this.maxAge.isEmpty() && this.expires.isEmpty();
    }

    Duration computeAge(Instant now) {
        Duration apparentAge = DateUtils.max(Duration.between(this.date.toInstant(ZoneOffset.UTC), this.timeResponseReceived), Duration.ZERO);
        Duration responseDelay = Duration.between(this.timeRequestSent, this.timeResponseReceived);
        Duration correctedAge = this.age.plus(responseDelay);
        Duration correctedInitialAge = DateUtils.max(apparentAge, correctedAge);
        Duration residentTime = Duration.between(this.timeResponseReceived, now);
        return correctedInitialAge.plus(residentTime);
    }
}

