/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol.internal.extensions;

import com.github.mizosoft.methanol.CacheAwareResponse;
import com.github.mizosoft.methanol.TrackedResponse;
import com.github.mizosoft.methanol.internal.Validate;
import com.github.mizosoft.methanol.internal.extensions.HeadersBuilder;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Instant;
import java.util.Optional;
import java.util.function.Consumer;
import javax.net.ssl.SSLSession;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ResponseBuilder<T> {
    private final HeadersBuilder headersBuilder = new HeadersBuilder();
    private int statusCode = -1;
    private @MonotonicNonNull URI uri;
    private  @MonotonicNonNull HttpClient.Version version;
    private @MonotonicNonNull HttpRequest request;
    private @MonotonicNonNull Instant timeRequestSent;
    private @MonotonicNonNull Instant timeResponseReceived;
    private @Nullable Object body;
    private @Nullable SSLSession sslSession;
    private @Nullable HttpResponse<T> previousResponse;
    private @Nullable TrackedResponse<?> networkResponse;
    private @Nullable TrackedResponse<?> cacheResponse;
    private @MonotonicNonNull CacheAwareResponse.CacheStatus cacheStatus;

    public ResponseBuilder<T> statusCode(int statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public ResponseBuilder<T> uri(URI uri) {
        this.uri = uri;
        return this;
    }

    public ResponseBuilder<T> version(HttpClient.Version version) {
        this.version = version;
        return this;
    }

    public ResponseBuilder<T> header(String name, String value) {
        this.headersBuilder.add(name, value);
        return this;
    }

    public ResponseBuilder<T> setHeader(String name, String value) {
        this.headersBuilder.set(name, value);
        return this;
    }

    public ResponseBuilder<T> headers(HttpHeaders headers) {
        this.headersBuilder.addAll(headers);
        return this;
    }

    public ResponseBuilder<T> clearHeaders() {
        this.headersBuilder.clear();
        return this;
    }

    public ResponseBuilder<T> removeHeader(String name) {
        this.headersBuilder.remove(name);
        return this;
    }

    public ResponseBuilder<T> request(HttpRequest request) {
        this.request = request;
        return this;
    }

    public ResponseBuilder<T> timeRequestSent(Instant timeRequestSent) {
        this.timeRequestSent = timeRequestSent;
        return this;
    }

    public ResponseBuilder<T> timeResponseReceived(Instant timeResponseReceived) {
        this.timeResponseReceived = timeResponseReceived;
        return this;
    }

    public <U> ResponseBuilder<U> body(@Nullable U body) {
        this.body = body;
        return this;
    }

    public ResponseBuilder<T> dropBody() {
        return this.body(null);
    }

    public ResponseBuilder<T> sslSession(@Nullable SSLSession sslSession) {
        this.sslSession = sslSession;
        return this;
    }

    public ResponseBuilder<T> previousResponse(@Nullable HttpResponse<T> previousResponse) {
        this.previousResponse = previousResponse;
        return this;
    }

    public ResponseBuilder<T> networkResponse(@Nullable TrackedResponse<?> networkResponse) {
        this.networkResponse = networkResponse;
        return this;
    }

    public ResponseBuilder<T> cacheResponse(@Nullable TrackedResponse<?> cacheResponse) {
        this.cacheResponse = cacheResponse;
        return this;
    }

    public ResponseBuilder<T> cacheStatus(CacheAwareResponse.CacheStatus cacheStatus) {
        this.cacheStatus = cacheStatus;
        return this;
    }

    public ResponseBuilder<T> apply(Consumer<ResponseBuilder<?>> consumer) {
        consumer.accept(this);
        return this;
    }

    public HttpResponse<T> build() {
        Validate.requireState(this.statusCode > 0, "statusCode is required");
        if (this.cacheStatus != null) {
            return this.buildCacheAware();
        }
        if (this.timeRequestSent != null && this.timeResponseReceived != null) {
            return this.buildTracked();
        }
        return new HttpResponseImpl<Object>(this.statusCode, ResponseBuilder.ensureSet(this.uri, "uri"), ResponseBuilder.ensureSet(this.version, "version"), this.headersBuilder.build(), ResponseBuilder.ensureSet(this.request, "request"), this.body, this.sslSession, this.previousResponse);
    }

    public TrackedResponse<T> buildTracked() {
        if (this.cacheStatus != null) {
            return this.buildCacheAware();
        }
        return new TrackedResponseImpl<Object>(this.statusCode, ResponseBuilder.ensureSet(this.uri, "uri"), ResponseBuilder.ensureSet(this.version, "version"), this.headersBuilder.build(), ResponseBuilder.ensureSet(this.request, "request"), this.body, this.sslSession, this.previousResponse, ResponseBuilder.ensureSet(this.timeRequestSent, "timeRequestSent"), ResponseBuilder.ensureSet(this.timeResponseReceived, "timeResponseReceived"));
    }

    private CacheAwareResponse<T> buildCacheAware() {
        Validate.requireState(this.statusCode > 0, "statusCode is required");
        return new CacheAwareResponseImpl<Object>(this.statusCode, ResponseBuilder.ensureSet(this.uri, "uri"), ResponseBuilder.ensureSet(this.version, "version"), this.headersBuilder.build(), ResponseBuilder.ensureSet(this.request, "request"), this.body, this.sslSession, this.previousResponse, ResponseBuilder.ensureSet(this.timeRequestSent, "timeRequestSent"), ResponseBuilder.ensureSet(this.timeResponseReceived, "timeResponseReceived"), this.networkResponse, this.cacheResponse, ResponseBuilder.ensureSet(this.cacheStatus, "cacheStatus"));
    }

    public static <T> ResponseBuilder<T> newBuilder(HttpResponse<T> response) {
        ResponseBuilder<T> builder = new ResponseBuilder<T>().statusCode(response.statusCode()).uri(response.uri()).version(response.version()).headers(response.headers()).request(response.request()).body(response.body());
        response.previousResponse().ifPresent(builder::previousResponse);
        response.sslSession().ifPresent(builder::sslSession);
        if (response instanceof TrackedResponse) {
            TrackedResponse trackedResponse = (TrackedResponse)response;
            builder.timeRequestSent(trackedResponse.timeRequestSent()).timeResponseReceived(trackedResponse.timeResponseReceived());
        }
        if (response instanceof CacheAwareResponse) {
            CacheAwareResponse cacheAwareResponse = (CacheAwareResponse)response;
            builder.networkResponse(cacheAwareResponse.networkResponse().orElse(null)).cacheResponse(cacheAwareResponse.cacheResponse().orElse(null)).cacheStatus(cacheAwareResponse.cacheStatus());
        }
        return builder;
    }

    private static <T> T ensureSet(T property, String name) {
        Validate.requireState(property != null, "%s is required", name);
        return Validate.castNonNull(property);
    }

    private static class HttpResponseImpl<T>
    implements HttpResponse<T> {
        private final int statusCode;
        private final URI uri;
        private final HttpClient.Version version;
        private final HttpHeaders headers;
        private final HttpRequest request;
        private final @Nullable T body;
        private final @Nullable SSLSession sslSession;
        private final @Nullable HttpResponse<T> previousResponse;

        HttpResponseImpl(int statusCode, URI uri, HttpClient.Version version, HttpHeaders headers, HttpRequest request, @Nullable T body, @Nullable SSLSession sslSession, @Nullable HttpResponse<T> previousResponse) {
            this.statusCode = statusCode;
            this.uri = uri;
            this.version = version;
            this.headers = headers;
            this.request = request;
            this.body = body;
            this.sslSession = sslSession;
            this.previousResponse = previousResponse;
        }

        @Override
        public int statusCode() {
            return this.statusCode;
        }

        @Override
        public HttpRequest request() {
            return this.request;
        }

        @Override
        public Optional<HttpResponse<T>> previousResponse() {
            return Optional.ofNullable(this.previousResponse);
        }

        @Override
        public HttpHeaders headers() {
            return this.headers;
        }

        @Override
        public T body() {
            return this.body;
        }

        @Override
        public Optional<SSLSession> sslSession() {
            return Optional.ofNullable(this.sslSession);
        }

        @Override
        public URI uri() {
            return this.uri;
        }

        @Override
        public HttpClient.Version version() {
            return this.version;
        }

        public String toString() {
            return "(" + this.request.method() + " " + this.request.uri() + ") " + this.statusCode;
        }
    }

    private static class TrackedResponseImpl<T>
    extends HttpResponseImpl<T>
    implements TrackedResponse<T> {
        private final Instant timeRequestSent;
        private final Instant timeResponseReceived;

        TrackedResponseImpl(int statusCode, URI uri, HttpClient.Version version, HttpHeaders headers, HttpRequest request, @Nullable T body, @Nullable SSLSession sslSession, @Nullable HttpResponse<T> previousResponse, Instant timeRequestSent, Instant timeResponseReceived) {
            super(statusCode, uri, version, headers, request, body, sslSession, previousResponse);
            this.timeRequestSent = timeRequestSent;
            this.timeResponseReceived = timeResponseReceived;
        }

        @Override
        public Instant timeRequestSent() {
            return this.timeRequestSent;
        }

        @Override
        public Instant timeResponseReceived() {
            return this.timeResponseReceived;
        }
    }

    private static final class CacheAwareResponseImpl<T>
    extends TrackedResponseImpl<T>
    implements CacheAwareResponse<T> {
        private final @Nullable TrackedResponse<?> networkResponse;
        private final @Nullable TrackedResponse<?> cacheResponse;
        private final CacheAwareResponse.CacheStatus cacheStatus;

        CacheAwareResponseImpl(int statusCode, URI uri, HttpClient.Version version, HttpHeaders headers, HttpRequest request, @Nullable T body, @Nullable SSLSession sslSession, @Nullable HttpResponse<T> previousResponse, Instant timeRequestSent, Instant timeResponseReceived, @Nullable TrackedResponse<?> networkResponse, @Nullable TrackedResponse<?> cacheResponse, CacheAwareResponse.CacheStatus cacheStatus) {
            super(statusCode, uri, version, headers, request, body, sslSession, previousResponse, timeRequestSent, timeResponseReceived);
            this.networkResponse = networkResponse;
            this.cacheResponse = cacheResponse;
            this.cacheStatus = cacheStatus;
        }

        @Override
        public Optional<TrackedResponse<?>> networkResponse() {
            return Optional.ofNullable(this.networkResponse);
        }

        @Override
        public Optional<TrackedResponse<?>> cacheResponse() {
            return Optional.ofNullable(this.cacheResponse);
        }

        @Override
        public CacheAwareResponse.CacheStatus cacheStatus() {
            return this.cacheStatus;
        }
    }
}

