/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol.internal.extensions;

import com.github.mizosoft.methanol.HttpReadTimeoutException;
import com.github.mizosoft.methanol.internal.concurrent.Delayer;
import com.github.mizosoft.methanol.internal.flow.TimeoutSubscriber;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;

public class TimeoutBodySubscriber<T>
extends TimeoutSubscriber<List<ByteBuffer>>
implements HttpResponse.BodySubscriber<T> {
    private final HttpResponse.BodySubscriber<T> downstream;

    public TimeoutBodySubscriber(Duration timeout, Delayer delayer, HttpResponse.BodySubscriber<T> downstream) {
        super(timeout, delayer);
        this.downstream = downstream;
    }

    @Override
    protected Flow.Subscriber<? super List<ByteBuffer>> downstream() {
        return this.downstream;
    }

    @Override
    protected Throwable timeoutError(long index, Duration timeout) {
        return new HttpReadTimeoutException(String.format("read [%d] timed out after %d ms", index, timeout.toMillis()));
    }

    @Override
    public CompletionStage<T> getBody() {
        return this.downstream.getBody();
    }
}

