/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol.internal.flow;

import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;

public class FlowSupport {
    private static final String PREFETCH_PROP = "com.github.mizosoft.methanol.flow.prefetch";
    private static final String PREFETCH_FACTOR_PROP = "com.github.mizosoft.methanol.flow.prefetchFactor";
    private static final int DEFAULT_PREFETCH = 16;
    private static final int DEFAULT_PREFETCH_FACTOR = 50;
    private static final int PREFETCH = FlowSupport.loadPrefetch();
    private static final int PREFETCH_THRESHOLD = (int)((float)PREFETCH * ((float)FlowSupport.loadPrefetchFactor() / 100.0f));
    public static final Flow.Subscription NOOP_SUBSCRIPTION = new Flow.Subscription(){

        @Override
        public void request(long n) {
        }

        @Override
        public void cancel() {
        }
    };
    private static final Flow.Publisher<?> EMPTY_PUBLISHER = subscriber -> {
        Objects.requireNonNull(subscriber);
        try {
            subscriber.onSubscribe(NOOP_SUBSCRIPTION);
        }
        catch (Throwable t) {
            subscriber.onError(t);
            return;
        }
        subscriber.onComplete();
    };
    public static final Executor SYNC_EXECUTOR = Runnable::run;

    private FlowSupport() {
    }

    static int loadPrefetch() {
        int prefetch = Integer.getInteger(PREFETCH_PROP, 16);
        if (prefetch <= 0) {
            return 16;
        }
        return prefetch;
    }

    static int loadPrefetchFactor() {
        int prefetchFactor = Integer.getInteger(PREFETCH_FACTOR_PROP, 50);
        if (prefetchFactor < 0 || prefetchFactor > 100) {
            prefetchFactor = 50;
        }
        return prefetchFactor;
    }

    public static IllegalArgumentException illegalRequest() {
        return new IllegalArgumentException("non-positive subscription request");
    }

    public static int prefetch() {
        return PREFETCH;
    }

    public static int prefetchThreshold() {
        return PREFETCH_THRESHOLD;
    }

    public static long getAndAddDemand(Object owner, VarHandle demand, long n) {
        long addedDemand;
        long currentDemand;
        do {
            if ((addedDemand = (currentDemand = demand.getVolatile(owner)) + n) >= 0L) continue;
            addedDemand = Long.MAX_VALUE;
        } while (!demand.compareAndSet(owner, currentDemand, addedDemand));
        return currentDemand;
    }

    public static long subtractAndGetDemand(Object owner, VarHandle demand, long n) {
        return demand.getAndAdd(owner, -n) - n;
    }

    public static <T> Flow.Publisher<T> emptyPublisher() {
        return EMPTY_PUBLISHER;
    }

    public static IllegalStateException multipleSubscribersToUnicast() {
        return new IllegalStateException("multiple subscribers to a unicast publisher");
    }

    public static void refuse(Flow.Subscriber<?> subscriber, Throwable error) {
        try {
            subscriber.onSubscribe(NOOP_SUBSCRIPTION);
        }
        catch (Throwable t) {
            error.addSuppressed(t);
        }
        finally {
            subscriber.onError(error);
        }
    }
}

