/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol.internal.flow;

import com.github.mizosoft.methanol.internal.concurrent.SerialExecutor;
import com.github.mizosoft.methanol.internal.flow.FlowSupport;
import com.github.mizosoft.methanol.internal.flow.ForwardingSubscriber;
import java.util.Objects;
import java.util.concurrent.Flow;

public abstract class SerializedSubscriber<T>
extends ForwardingSubscriber<T> {
    private final SerialExecutor serialExecutor = new SerialExecutor(FlowSupport.SYNC_EXECUTOR);
    private boolean done;

    protected SerializedSubscriber() {
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        Objects.requireNonNull(subscription);
        this.serialExecutor.execute(() -> super.onSubscribe(subscription));
    }

    @Override
    public void onNext(T item) {
        Objects.requireNonNull(item);
        this.serialExecutor.execute(() -> {
            if (!this.done) {
                super.onNext(item);
            }
        });
    }

    @Override
    public void onError(Throwable throwable) {
        Objects.requireNonNull(throwable);
        this.serialExecutor.execute(() -> {
            if (!this.done) {
                this.done = true;
                super.onError(throwable);
            }
        });
    }

    @Override
    public void onComplete() {
        this.serialExecutor.execute(() -> {
            if (!this.done) {
                this.done = true;
                super.onComplete();
            }
        });
    }
}

