/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol.internal.flow;

import com.github.mizosoft.methanol.internal.flow.FlowSupport;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.concurrent.Flow;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Upstream {
    private static final VarHandle SUBSCRIPTION;
    private volatile  @Nullable Flow.Subscription subscription;

    public boolean isSet() {
        return this.subscription != null;
    }

    public boolean setOrCancel(Flow.Subscription incoming) {
        if (!SUBSCRIPTION.compareAndSet(this, null, incoming)) {
            incoming.cancel();
            return false;
        }
        return true;
    }

    public void request(long n) {
        Flow.Subscription currentSubscription = this.subscription;
        if (currentSubscription != null) {
            currentSubscription.request(n);
        }
    }

    public void cancel() {
        Flow.Subscription currentSubscription = SUBSCRIPTION.getAndSet(this, FlowSupport.NOOP_SUBSCRIPTION);
        if (currentSubscription != null) {
            currentSubscription.cancel();
        }
    }

    public void clear() {
        this.subscription = FlowSupport.NOOP_SUBSCRIPTION;
    }

    static {
        try {
            SUBSCRIPTION = MethodHandles.lookup().findVarHandle(Upstream.class, "subscription", Flow.Subscription.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

