/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol.internal.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.concurrent.locks.ReentrantLock;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public final class ServiceCache<S> {
    private static final System.Logger logger = System.getLogger(ServiceCache.class.getName());
    private final Class<S> service;
    private final ReentrantLock lock = new ReentrantLock();
    private volatile @MonotonicNonNull List<S> providers;

    public ServiceCache(Class<S> service) {
        this.service = Objects.requireNonNull(service);
    }

    public List<S> getProviders() {
        List<S> cached = this.providers;
        if (cached == null) {
            if (this.lock.isHeldByCurrentThread()) {
                throw new ServiceConfigurationError("recursive loading of providers");
            }
            this.lock.lock();
            try {
                cached = this.providers;
                if (cached == null) {
                    this.providers = cached = this.loadProviders();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return cached;
    }

    private List<S> loadProviders() {
        ArrayList providers = new ArrayList();
        ServiceLoader.load(this.service, ServiceCache.class.getClassLoader()).stream().forEach(provider -> this.addProviderLenient((ServiceLoader.Provider<S>)provider, providers));
        return Collections.unmodifiableList(providers);
    }

    private void addProviderLenient(ServiceLoader.Provider<S> provider, List<S> providers) {
        try {
            providers.add(provider.get());
        }
        catch (ServiceConfigurationError error) {
            logger.log(System.Logger.Level.WARNING, "provider <" + provider.type() + "> will be ignored as it couldn't be instantiated", (Throwable)error);
        }
    }
}

