/*
 * Decompiled with CFR 0.152.
 */
package com.github.monkeywie.proxyee.crt;

import com.github.monkeywie.proxyee.crt.service.bc.BouncyCastleCertGenerator;
import com.github.monkeywie.proxyee.crt.spi.CertGenerator;
import com.github.monkeywie.proxyee.crt.spi.CertGeneratorInfo;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;

public final class CertUtilsLoader {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(CertUtilsLoader.class);
    public static final String DEFAULT_GENERATOR_NAME = "BouncyCastle";
    private static final Map<String, CertGenerator> generatorMap = new Hashtable<String, CertGenerator>();
    private static final AtomicReference<String> selectionGenerator = new AtomicReference<String>("BouncyCastle");

    private CertUtilsLoader() {
    }

    private static void loadGenerator() {
        ServiceLoader<CertGenerator> serviceLoader = ServiceLoader.load(CertGenerator.class);
        for (CertGenerator generator : serviceLoader) {
            Class<?> generatorClass = generator.getClass();
            if (!generatorClass.isAnnotationPresent(CertGeneratorInfo.class)) {
                log.warn("CertGeneratorInfo annotation not found for implementation class {}", (Object)generatorClass.getName());
                continue;
            }
            CertGeneratorInfo info = generatorClass.getAnnotation(CertGeneratorInfo.class);
            String generatorName = info.name().trim();
            if (generatorName.isEmpty()) {
                log.warn("Implementation class {} name is empty", (Object)generatorClass.getName());
                continue;
            }
            if (generatorMap.containsKey(generatorName)) {
                CertGenerator currentGenerator = generatorMap.get(generatorName);
                log.warn("A loaded implementation already exists for name {} (current implementation: {}), skipping implementation {}}", new Object[]{generatorName, currentGenerator.getClass().getName(), generatorClass.getName()});
                continue;
            }
            generatorMap.put(generatorName, generator);
            log.debug("Generator implementation loaded (Name: {}, implementation class: {})", (Object)generatorName, (Object)generatorClass.getName());
        }
    }

    public static void setSelectionGenerator(String generatorName) throws NoSuchElementException {
        if (!generatorMap.containsKey(generatorName.trim())) {
            throw new NoSuchElementException("The specified generator was not found: " + generatorName);
        }
        selectionGenerator.set(generatorName.trim());
    }

    private static CertGenerator checkGenerateExistAndGet(String name) {
        if (!generatorMap.containsKey(name)) {
            throw new NoSuchElementException("The certificate generator with the specified name was not found: " + name);
        }
        return generatorMap.get(name);
    }

    public static String getCurrentSelectionGenerator() {
        return selectionGenerator.get();
    }

    public static X509Certificate generateServerCert(String issuer, PrivateKey caPriKey, Date caNotBefore, Date caNotAfter, PublicKey serverPubKey, String ... hosts) throws Exception {
        return CertUtilsLoader.checkGenerateExistAndGet(selectionGenerator.get()).generateServerCert(issuer, caPriKey, caNotBefore, caNotAfter, serverPubKey, hosts);
    }

    public static X509Certificate generateCaCert(String subject, Date caNotBefore, Date caNotAfter, KeyPair keyPair) throws Exception {
        return CertUtilsLoader.checkGenerateExistAndGet(selectionGenerator.get()).generateCaCert(subject, caNotBefore, caNotAfter, keyPair);
    }

    static {
        try {
            CertUtilsLoader.loadGenerator();
        }
        catch (Exception e) {
            log.error("An uncaught exception was thrown while loading the certificate generator", (Throwable)e);
            generatorMap.put(DEFAULT_GENERATOR_NAME, new BouncyCastleCertGenerator());
        }
    }
}

