/*
 * Decompiled with CFR 0.152.
 */
package com.github.monkeywie.proxyee.handler;

import com.github.monkeywie.proxyee.exception.HttpProxyExceptionHandle;
import com.github.monkeywie.proxyee.handler.HttpProxyServerHandler;
import com.github.monkeywie.proxyee.intercept.HttpProxyInterceptPipeline;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.util.ReferenceCountUtil;

public class HttpProxyClientHandler
extends ChannelInboundHandlerAdapter {
    private Channel clientChannel;

    public HttpProxyClientHandler(Channel clientChannel) {
        this.clientChannel = clientChannel;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!this.clientChannel.isOpen()) {
            ReferenceCountUtil.release((Object)msg);
            return;
        }
        HttpProxyInterceptPipeline interceptPipeline = ((HttpProxyServerHandler)this.clientChannel.pipeline().get("serverHandle")).getInterceptPipeline();
        if (msg instanceof HttpResponse) {
            DecoderResult decoderResult = ((HttpResponse)msg).decoderResult();
            Throwable cause = decoderResult.cause();
            if (cause != null) {
                ReferenceCountUtil.release((Object)msg);
                this.exceptionCaught(ctx, cause);
                return;
            }
            interceptPipeline.afterResponse(this.clientChannel, ctx.channel(), (HttpResponse)msg);
        } else if (msg instanceof HttpContent) {
            interceptPipeline.afterResponse(this.clientChannel, ctx.channel(), (HttpContent)msg);
        } else {
            this.clientChannel.writeAndFlush(msg);
        }
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        ctx.channel().close();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ctx.channel().close();
        this.clientChannel.close();
        HttpProxyExceptionHandle exceptionHandle = ((HttpProxyServerHandler)this.clientChannel.pipeline().get("serverHandle")).getExceptionHandle();
        exceptionHandle.afterCatch(this.clientChannel, ctx.channel(), cause);
    }
}

