/*
 * Decompiled with CFR 0.152.
 */
package com.github.monkeywie.proxyee.handler;

import com.github.monkeywie.proxyee.handler.HttpProxyClientHandler;
import com.github.monkeywie.proxyee.handler.HttpProxyServerHandler;
import com.github.monkeywie.proxyee.server.HttpProxyServerConfig;
import com.github.monkeywie.proxyee.util.ProtoUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.proxy.ProxyHandler;

public class HttpProxyInitializer
extends ChannelInitializer {
    private Channel clientChannel;
    private ProtoUtil.RequestProto requestProto;
    private ProxyHandler proxyHandler;

    public HttpProxyInitializer(Channel clientChannel, ProtoUtil.RequestProto requestProto, ProxyHandler proxyHandler) {
        this.clientChannel = clientChannel;
        this.requestProto = requestProto;
        this.proxyHandler = proxyHandler;
    }

    protected void initChannel(Channel ch) throws Exception {
        if (this.proxyHandler != null) {
            ch.pipeline().addLast(new ChannelHandler[]{this.proxyHandler});
        }
        HttpProxyServerConfig serverConfig = ((HttpProxyServerHandler)this.clientChannel.pipeline().get("serverHandle")).getServerConfig();
        if (this.requestProto.getSsl()) {
            ch.pipeline().addLast(new ChannelHandler[]{serverConfig.getClientSslCtx().newHandler(ch.alloc(), this.requestProto.getHost(), this.requestProto.getPort())});
        }
        ch.pipeline().addLast("httpCodec", (ChannelHandler)new HttpClientCodec(serverConfig.getMaxInitialLineLength(), serverConfig.getMaxHeaderSize(), serverConfig.getMaxChunkSize()));
        ch.pipeline().addLast("proxyClientHandle", (ChannelHandler)new HttpProxyClientHandler(this.clientChannel));
    }
}

