/*
 * Decompiled with CFR 0.152.
 */
package com.github.monkeywie.proxyee.handler;

import com.github.monkeywie.proxyee.crt.CertPool;
import com.github.monkeywie.proxyee.exception.HttpProxyExceptionHandle;
import com.github.monkeywie.proxyee.handler.HttpProxyInitializer;
import com.github.monkeywie.proxyee.handler.TunnelProxyInitializer;
import com.github.monkeywie.proxyee.intercept.HttpProxyIntercept;
import com.github.monkeywie.proxyee.intercept.HttpProxyInterceptInitializer;
import com.github.monkeywie.proxyee.intercept.HttpProxyInterceptPipeline;
import com.github.monkeywie.proxyee.proxy.ProxyConfig;
import com.github.monkeywie.proxyee.proxy.ProxyHandleFactory;
import com.github.monkeywie.proxyee.server.HttpProxyServer;
import com.github.monkeywie.proxyee.server.HttpProxyServerConfig;
import com.github.monkeywie.proxyee.server.auth.HttpAuthContext;
import com.github.monkeywie.proxyee.server.auth.HttpProxyAuthenticationProvider;
import com.github.monkeywie.proxyee.util.ProtoUtil;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.TooLongHttpContentException;
import io.netty.handler.codec.http.TooLongHttpHeaderException;
import io.netty.handler.codec.http.TooLongHttpLineException;
import io.netty.handler.proxy.ProxyHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.NoopAddressResolverGroup;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.URL;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import java.util.List;

public class HttpProxyServerHandler
extends ChannelInboundHandlerAdapter {
    private ChannelFuture cf;
    private ProtoUtil.RequestProto requestProto;
    private int status = 0;
    private final HttpProxyServerConfig serverConfig;
    private final ProxyConfig proxyConfig;
    private final HttpProxyInterceptInitializer interceptInitializer;
    private HttpProxyInterceptPipeline interceptPipeline;
    private final HttpProxyExceptionHandle exceptionHandle;
    private List requestList;
    private boolean isConnect;
    private byte[] httpTagBuf;

    protected ChannelFuture getChannelFuture() {
        return this.cf;
    }

    protected void setChannelFuture(ChannelFuture cf) {
        this.cf = cf;
    }

    public HttpProxyExceptionHandle getExceptionHandle() {
        return this.exceptionHandle;
    }

    public HttpProxyInterceptInitializer getInterceptInitializer() {
        return this.interceptInitializer;
    }

    protected boolean getIsConnect() {
        return this.isConnect;
    }

    protected void setIsConnect(boolean isConnect) {
        this.isConnect = isConnect;
    }

    protected List getRequestList() {
        return this.requestList;
    }

    protected void setRequestList(List requestList) {
        this.requestList = requestList;
    }

    public ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    protected ProtoUtil.RequestProto getRequestProto() {
        return this.requestProto;
    }

    protected void setRequestProto(ProtoUtil.RequestProto requestProto) {
        this.requestProto = requestProto;
    }

    public HttpProxyServerConfig getServerConfig() {
        return this.serverConfig;
    }

    protected int getStatus() {
        return this.status;
    }

    protected void setStatus(int status) {
        this.status = status;
    }

    public HttpProxyInterceptPipeline getInterceptPipeline() {
        return this.interceptPipeline;
    }

    protected void setInterceptPipeline(HttpProxyInterceptPipeline interceptPipeline) {
        this.interceptPipeline = interceptPipeline;
    }

    public HttpProxyServerHandler(HttpProxyServerConfig serverConfig, HttpProxyInterceptInitializer interceptInitializer, ProxyConfig proxyConfig, HttpProxyExceptionHandle exceptionHandle) {
        this.serverConfig = serverConfig;
        this.proxyConfig = proxyConfig;
        this.interceptInitializer = interceptInitializer;
        this.exceptionHandle = exceptionHandle;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpRequest) {
            HttpRequest request = (HttpRequest)msg;
            DecoderResult result = request.decoderResult();
            Throwable cause = result.cause();
            if (cause instanceof DecoderException) {
                this.setStatus(2);
                HttpResponseStatus status = null;
                if (cause instanceof TooLongHttpLineException) {
                    status = HttpResponseStatus.REQUEST_URI_TOO_LONG;
                } else if (cause instanceof TooLongHttpHeaderException) {
                    status = HttpResponseStatus.REQUEST_HEADER_FIELDS_TOO_LARGE;
                } else if (cause instanceof TooLongHttpContentException) {
                    status = HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE;
                }
                if (status == null) {
                    status = HttpResponseStatus.BAD_REQUEST;
                }
                DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status);
                ctx.writeAndFlush((Object)response);
                ReferenceCountUtil.release((Object)msg);
                return;
            }
            if (this.getStatus() == 0) {
                this.setRequestProto(ProtoUtil.getRequestProto(request));
                if (this.getRequestProto() == null) {
                    ctx.channel().close();
                    return;
                }
                if (this.getServerConfig().getHttpProxyAcceptHandler() != null && !this.getServerConfig().getHttpProxyAcceptHandler().onAccept(request, ctx.channel())) {
                    this.setStatus(2);
                    ctx.channel().close();
                    return;
                }
                if (!this.authenticate(ctx, request)) {
                    this.setStatus(2);
                    ctx.channel().close();
                    return;
                }
                this.setStatus(1);
                if (HttpMethod.CONNECT.name().equalsIgnoreCase(request.method().name())) {
                    this.setStatus(2);
                    DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpProxyServer.SUCCESS);
                    ctx.writeAndFlush((Object)response);
                    ctx.channel().pipeline().remove("httpCodec");
                    ReferenceCountUtil.release((Object)msg);
                    return;
                }
            }
            this.setInterceptPipeline(this.buildPipeline());
            this.getInterceptPipeline().setRequestProto(this.getRequestProto().copy());
            if (request.uri().indexOf("/") != 0) {
                URL url = new URL(request.uri());
                request.setUri(url.getFile());
            }
            this.getInterceptPipeline().beforeRequest(ctx.channel(), request);
            ReferenceCountUtil.release((Object)msg);
        } else if (msg instanceof HttpContent) {
            if (this.getStatus() != 2) {
                this.getInterceptPipeline().beforeRequest(ctx.channel(), (HttpContent)msg);
            } else {
                ReferenceCountUtil.release((Object)msg);
                this.setStatus(1);
            }
        } else {
            ByteBuf byteBuf = (ByteBuf)msg;
            if (this.getServerConfig().isHandleSsl() && byteBuf.getByte(0) == 22 && this.doMitm()) {
                this.getRequestProto().setSsl(true);
                int port = ((InetSocketAddress)ctx.channel().localAddress()).getPort();
                SslContext sslCtx = SslContextBuilder.forServer((PrivateKey)this.getServerConfig().getServerPriKey(), (X509Certificate[])new X509Certificate[]{CertPool.getCert(port, this.getRequestProto().getHost(), this.getServerConfig())}).build();
                ctx.pipeline().addFirst("httpCodec", (ChannelHandler)new HttpServerCodec(this.getServerConfig().getMaxInitialLineLength(), this.getServerConfig().getMaxHeaderSize(), this.getServerConfig().getMaxChunkSize()));
                ctx.pipeline().addFirst("sslHandle", (ChannelHandler)sslCtx.newHandler(ctx.alloc()));
                ctx.pipeline().fireChannelRead(msg);
                return;
            }
            if (byteBuf.readableBytes() < 8) {
                this.httpTagBuf = new byte[byteBuf.readableBytes()];
                byteBuf.readBytes(this.httpTagBuf);
                ReferenceCountUtil.release((Object)msg);
                return;
            }
            if (this.httpTagBuf != null) {
                byte[] tmp = new byte[byteBuf.readableBytes()];
                byteBuf.readBytes(tmp);
                byteBuf.writeBytes(this.httpTagBuf);
                byteBuf.writeBytes(tmp);
                this.httpTagBuf = null;
            }
            if (this.isHttp(byteBuf)) {
                ctx.pipeline().addFirst("httpCodec", (ChannelHandler)new HttpServerCodec(this.getServerConfig().getMaxInitialLineLength(), this.getServerConfig().getMaxHeaderSize(), this.getServerConfig().getMaxChunkSize()));
                ctx.pipeline().fireChannelRead(msg);
                return;
            }
            this.handleProxyData(ctx.channel(), msg, false);
        }
    }

    private boolean doMitm() {
        return this.getServerConfig().getMitmMatcher() == null || this.getServerConfig().getMitmMatcher().doMatch(this.getRequestProto());
    }

    private boolean isHttp(ByteBuf byteBuf) {
        byte[] bytes = new byte[8];
        byteBuf.getBytes(0, bytes);
        String methodToken = new String(bytes);
        return methodToken.startsWith("GET ") || methodToken.startsWith("POST ") || methodToken.startsWith("HEAD ") || methodToken.startsWith("PUT ") || methodToken.startsWith("DELETE ") || methodToken.startsWith("OPTIONS ") || methodToken.startsWith("CONNECT ") || methodToken.startsWith("TRACE ");
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        if (this.getChannelFuture() != null) {
            this.getChannelFuture().channel().close();
        }
        ctx.channel().close();
        if (this.getServerConfig().getHttpProxyAcceptHandler() != null) {
            this.getServerConfig().getHttpProxyAcceptHandler().onClose(ctx.channel());
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (this.getChannelFuture() != null) {
            this.getChannelFuture().channel().close();
        }
        ctx.channel().close();
        this.exceptionHandle.beforeCatch(ctx.channel(), cause);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            ctx.channel().close();
        }
    }

    private boolean authenticate(ChannelHandlerContext ctx, HttpRequest request) {
        if (this.serverConfig.getAuthenticationProvider() != null) {
            HttpProxyAuthenticationProvider authProvider = this.serverConfig.getAuthenticationProvider();
            if (!authProvider.matches(request)) {
                return true;
            }
            Object httpToken = authProvider.authenticate(request);
            if (httpToken == null) {
                DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpProxyServer.UNAUTHORIZED);
                response.headers().set((CharSequence)HttpHeaderNames.PROXY_AUTHENTICATE, (Object)(authProvider.authType() + " realm=\"" + authProvider.authRealm() + "\""));
                ctx.writeAndFlush((Object)response);
                return false;
            }
            HttpAuthContext.setToken(ctx.channel(), httpToken);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleProxyData(Channel channel, Object msg, boolean isHttp) throws Exception {
        if (this.getInterceptPipeline() == null) {
            this.setInterceptPipeline(this.buildOnlyConnectPipeline());
            this.getInterceptPipeline().setRequestProto(this.getRequestProto().copy());
        }
        ProtoUtil.RequestProto pipeRp = this.getInterceptPipeline().getRequestProto();
        boolean isChangeRp = false;
        if (isHttp && msg instanceof HttpRequest && !pipeRp.equals(this.getRequestProto())) {
            isChangeRp = true;
        }
        if (isChangeRp || this.getChannelFuture() == null) {
            if (isHttp && !(msg instanceof HttpRequest)) {
                return;
            }
            this.getInterceptPipeline().beforeConnect(channel);
            ProxyHandler proxyHandler = ProxyHandleFactory.build(this.getInterceptPipeline().getProxyConfig() == null ? this.proxyConfig : this.getInterceptPipeline().getProxyConfig());
            ChannelInitializer channelInitializer = isHttp ? new HttpProxyInitializer(channel, pipeRp, proxyHandler) : new TunnelProxyInitializer(channel, proxyHandler);
            Bootstrap bootstrap = new Bootstrap();
            ((Bootstrap)((Bootstrap)bootstrap.group(this.getServerConfig().getProxyLoopGroup())).channel(NioSocketChannel.class)).handler((ChannelHandler)channelInitializer);
            if (proxyHandler != null) {
                bootstrap.resolver((AddressResolverGroup)NoopAddressResolverGroup.INSTANCE);
            } else {
                bootstrap.resolver(this.getServerConfig().resolver());
            }
            this.setRequestList(new LinkedList());
            this.setChannelFuture(bootstrap.connect(pipeRp.getHost(), pipeRp.getPort()));
            this.getChannelFuture().addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                if (future.isSuccess()) {
                    future.channel().writeAndFlush(msg);
                    List list = this.getRequestList();
                    synchronized (list) {
                        this.getRequestList().forEach(obj -> future.channel().writeAndFlush(obj));
                        this.getRequestList().clear();
                        this.setIsConnect(true);
                    }
                }
                List list = this.getRequestList();
                synchronized (list) {
                    this.getRequestList().forEach(obj -> ReferenceCountUtil.release((Object)obj));
                    this.getRequestList().clear();
                }
                this.getExceptionHandle().beforeCatch(channel, future.cause());
                future.channel().close();
                channel.close();
            }));
        } else {
            List list = this.getRequestList();
            synchronized (list) {
                if (this.getIsConnect()) {
                    this.getChannelFuture().channel().writeAndFlush(msg);
                } else {
                    this.getRequestList().add(msg);
                }
            }
        }
    }

    private HttpProxyInterceptPipeline buildPipeline() {
        HttpProxyInterceptPipeline interceptPipeline = new HttpProxyInterceptPipeline(new HttpProxyIntercept(){

            @Override
            public void beforeRequest(Channel clientChannel, HttpRequest httpRequest, HttpProxyInterceptPipeline pipeline) throws Exception {
                HttpProxyServerHandler.this.handleProxyData(clientChannel, httpRequest, true);
            }

            @Override
            public void beforeRequest(Channel clientChannel, HttpContent httpContent, HttpProxyInterceptPipeline pipeline) throws Exception {
                HttpProxyServerHandler.this.handleProxyData(clientChannel, httpContent, true);
            }

            @Override
            public void afterResponse(Channel clientChannel, Channel proxyChannel, HttpResponse httpResponse, HttpProxyInterceptPipeline pipeline) throws Exception {
                clientChannel.writeAndFlush((Object)httpResponse);
                if (HttpHeaderValues.WEBSOCKET.toString().equals(httpResponse.headers().get((CharSequence)HttpHeaderNames.UPGRADE))) {
                    proxyChannel.pipeline().remove("httpCodec");
                    clientChannel.pipeline().remove("httpCodec");
                }
            }

            @Override
            public void afterResponse(Channel clientChannel, Channel proxyChannel, HttpContent httpContent, HttpProxyInterceptPipeline pipeline) throws Exception {
                clientChannel.writeAndFlush((Object)httpContent);
            }
        });
        this.getInterceptInitializer().init(interceptPipeline);
        return interceptPipeline;
    }

    private HttpProxyInterceptPipeline buildOnlyConnectPipeline() {
        HttpProxyInterceptPipeline interceptPipeline = new HttpProxyInterceptPipeline(new HttpProxyIntercept());
        this.getInterceptInitializer().init(interceptPipeline);
        return interceptPipeline;
    }
}

