/*
 * Decompiled with CFR 0.152.
 */
package com.github.monkeywie.proxyee.intercept.common;

import com.github.monkeywie.proxyee.intercept.HttpProxyIntercept;
import com.github.monkeywie.proxyee.intercept.HttpProxyInterceptPipeline;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;

public abstract class FullRequestIntercept
extends HttpProxyIntercept {
    private static final int DEFAULT_MAX_CONTENT_LENGTH = 0x800000;
    private int maxContentLength;

    public FullRequestIntercept() {
        this(0x800000);
    }

    public FullRequestIntercept(int maxContentLength) {
        this.maxContentLength = maxContentLength;
    }

    @Override
    public final void beforeRequest(Channel clientChannel, HttpRequest httpRequest, HttpProxyInterceptPipeline pipeline) throws Exception {
        if (httpRequest instanceof FullHttpRequest) {
            FullHttpRequest fullHttpRequest = (FullHttpRequest)httpRequest;
            this.handleRequest(fullHttpRequest, pipeline);
            fullHttpRequest.content().markReaderIndex();
            fullHttpRequest.content().retain();
            if (fullHttpRequest.headers().contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH)) {
                fullHttpRequest.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)fullHttpRequest.content().readableBytes());
            }
        } else if (this.match(httpRequest, pipeline)) {
            pipeline.resetBeforeHead();
            clientChannel.pipeline().addAfter("httpCodec", "decompress", (ChannelHandler)new HttpContentDecompressor());
            clientChannel.pipeline().addAfter("decompress", "aggregator", (ChannelHandler)new HttpObjectAggregator(this.maxContentLength));
            clientChannel.pipeline().fireChannelRead((Object)httpRequest);
            return;
        }
        pipeline.beforeRequest(clientChannel, httpRequest);
    }

    @Override
    public void afterResponse(Channel clientChannel, Channel proxyChannel, HttpResponse httpResponse, HttpProxyInterceptPipeline pipeline) throws Exception {
        if (pipeline.getHttpRequest() instanceof FullHttpRequest) {
            if (clientChannel.pipeline().get("decompress") != null) {
                clientChannel.pipeline().remove("decompress");
            }
            if (clientChannel.pipeline().get("aggregator") != null) {
                clientChannel.pipeline().remove("aggregator");
            }
            FullHttpRequest httpRequest = (FullHttpRequest)pipeline.getHttpRequest();
            httpRequest.content().resetReaderIndex();
        }
        pipeline.afterResponse(clientChannel, proxyChannel, httpResponse);
    }

    public abstract boolean match(HttpRequest var1, HttpProxyInterceptPipeline var2);

    public void handleRequest(FullHttpRequest httpRequest, HttpProxyInterceptPipeline pipeline) {
    }
}

