/*
 * Decompiled with CFR 0.152.
 */
package com.github.monkeywie.proxyee.server;

import com.github.monkeywie.proxyee.config.IdleStateCheck;
import com.github.monkeywie.proxyee.crt.CertPool;
import com.github.monkeywie.proxyee.crt.CertUtil;
import com.github.monkeywie.proxyee.exception.HttpProxyExceptionHandle;
import com.github.monkeywie.proxyee.handler.HttpProxyServerHandler;
import com.github.monkeywie.proxyee.intercept.HttpProxyInterceptInitializer;
import com.github.monkeywie.proxyee.proxy.ProxyConfig;
import com.github.monkeywie.proxyee.server.HttpProxyCACertFactory;
import com.github.monkeywie.proxyee.server.HttpProxyServerConfig;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class HttpProxyServer {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(HttpProxyServer.class);
    public static final HttpResponseStatus SUCCESS = new HttpResponseStatus(200, "Connection established");
    public static final HttpResponseStatus UNAUTHORIZED = new HttpResponseStatus(407, "Unauthorized");
    private HttpProxyCACertFactory caCertFactory;
    private HttpProxyServerConfig serverConfig;
    private HttpProxyInterceptInitializer proxyInterceptInitializer;
    private HttpProxyExceptionHandle httpProxyExceptionHandle;
    private ProxyConfig proxyConfig;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;

    private void init() {
        if (this.serverConfig == null) {
            this.serverConfig = new HttpProxyServerConfig();
        }
        this.serverConfig.setProxyLoopGroup((EventLoopGroup)new NioEventLoopGroup(this.serverConfig.getProxyGroupThreads()));
        SslContextBuilder contextBuilder = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE);
        if (this.serverConfig.getCiphers() != null) {
            contextBuilder.ciphers(this.serverConfig.getCiphers());
        }
        try {
            this.serverConfig.setClientSslCtx(contextBuilder.build());
            if (this.serverConfig.isHandleSsl()) {
                PrivateKey caPriKey;
                X509Certificate caCert;
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                if (this.caCertFactory == null) {
                    caCert = CertUtil.loadCert(classLoader.getResourceAsStream("ca.crt"));
                    caPriKey = CertUtil.loadPriKey(classLoader.getResourceAsStream("ca_private.der"));
                } else {
                    caCert = this.caCertFactory.getCACert();
                    caPriKey = this.caCertFactory.getCAPriKey();
                }
                this.serverConfig.setIssuer(CertUtil.getSubject(caCert));
                this.serverConfig.setCaNotBefore(caCert.getNotBefore());
                this.serverConfig.setCaNotAfter(caCert.getNotAfter());
                this.serverConfig.setCaPriKey(caPriKey);
                KeyPair keyPair = CertUtil.genKeyPair();
                this.serverConfig.setServerPriKey(keyPair.getPrivate());
                this.serverConfig.setServerPubKey(keyPair.getPublic());
            }
        }
        catch (Exception e) {
            this.serverConfig.setHandleSsl(false);
            log.warn("SSL init fail,cause:" + e.getMessage());
        }
        if (this.proxyInterceptInitializer == null) {
            this.proxyInterceptInitializer = new HttpProxyInterceptInitializer();
        }
        if (this.httpProxyExceptionHandle == null) {
            this.httpProxyExceptionHandle = new HttpProxyExceptionHandle();
        }
    }

    public HttpProxyServer serverConfig(HttpProxyServerConfig serverConfig) {
        this.serverConfig = serverConfig;
        return this;
    }

    public HttpProxyServer proxyInterceptInitializer(HttpProxyInterceptInitializer proxyInterceptInitializer) {
        this.proxyInterceptInitializer = proxyInterceptInitializer;
        return this;
    }

    public HttpProxyServer httpProxyExceptionHandle(HttpProxyExceptionHandle httpProxyExceptionHandle) {
        this.httpProxyExceptionHandle = httpProxyExceptionHandle;
        return this;
    }

    public HttpProxyServer proxyConfig(ProxyConfig proxyConfig) {
        this.proxyConfig = proxyConfig;
        return this;
    }

    public HttpProxyServer caCertFactory(HttpProxyCACertFactory caCertFactory) {
        this.caCertFactory = caCertFactory;
        return this;
    }

    public void start(int port) {
        this.start(null, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String ip, int port) {
        try {
            ChannelFuture channelFuture = this.doBind(ip, port);
            CountDownLatch latch = new CountDownLatch(1);
            channelFuture.addListener(future -> {
                if (future.cause() != null) {
                    this.httpProxyExceptionHandle.startCatch(future.cause());
                }
                latch.countDown();
            });
            latch.await();
            channelFuture.channel().closeFuture().sync();
        }
        catch (Exception e) {
            this.httpProxyExceptionHandle.startCatch(e);
        }
        finally {
            this.close();
        }
    }

    public CompletionStage<Void> startAsync(int port) {
        return this.startAsync(null, port);
    }

    public CompletionStage<Void> startAsync(String ip, int port) {
        ChannelFuture channelFuture = this.doBind(ip, port);
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        channelFuture.addListener(start -> {
            if (start.isSuccess()) {
                future.complete(null);
                this.shutdownHook();
            } else {
                future.completeExceptionally(start.cause());
                this.close();
            }
        });
        return future;
    }

    private ChannelFuture doBind(String ip, int port) {
        this.init();
        this.bossGroup = new NioEventLoopGroup(this.serverConfig.getBossGroupThreads());
        this.workerGroup = new NioEventLoopGroup(this.serverConfig.getWorkerGroupThreads());
        ServerBootstrap bootstrap = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)bootstrap.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.DEBUG))).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ch.pipeline().addLast("httpCodec", (ChannelHandler)new HttpServerCodec(HttpProxyServer.this.serverConfig.getMaxInitialLineLength(), HttpProxyServer.this.serverConfig.getMaxHeaderSize(), HttpProxyServer.this.serverConfig.getMaxChunkSize()));
                if (HttpProxyServer.this.serverConfig.getIdleStateCheck() != null) {
                    IdleStateCheck idleStateCheck = HttpProxyServer.this.serverConfig.getIdleStateCheck();
                    ch.pipeline().addLast("idleStateCheck", (ChannelHandler)new IdleStateHandler(idleStateCheck.getReaderIdleTime(), idleStateCheck.getWriterIdleTime(), idleStateCheck.getAllIdleTime(), TimeUnit.MILLISECONDS));
                }
                ch.pipeline().addLast("serverHandle", (ChannelHandler)new HttpProxyServerHandler(HttpProxyServer.this.serverConfig, HttpProxyServer.this.proxyInterceptInitializer, HttpProxyServer.this.proxyConfig, HttpProxyServer.this.httpProxyExceptionHandle));
            }
        });
        return ip == null ? bootstrap.bind(port) : bootstrap.bind(ip, port);
    }

    public void close() {
        EventLoopGroup eventLoopGroup = this.serverConfig.getProxyLoopGroup();
        if (!eventLoopGroup.isShutdown() && !eventLoopGroup.isShuttingDown()) {
            eventLoopGroup.shutdownGracefully();
        }
        if (!this.bossGroup.isShutdown() && !this.bossGroup.isShuttingDown()) {
            this.bossGroup.shutdownGracefully();
        }
        if (!this.workerGroup.isShutdown() && !this.workerGroup.isShuttingDown()) {
            this.workerGroup.shutdownGracefully();
        }
        CertPool.clear();
    }

    public void shutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(this::close, "Server Shutdown Thread"));
    }
}

