/*
 * Decompiled with CFR 0.152.
 */
package com.github.monkeywie.proxyee.util;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;

public class ProtoUtil {
    public static RequestProto getRequestProto(HttpRequest httpRequest) {
        URL url;
        RequestProto requestProto = new RequestProto();
        String uri = httpRequest.uri().toLowerCase();
        if (!uri.startsWith("http://")) {
            uri = "http://" + uri;
        }
        try {
            url = new URL(uri);
        }
        catch (MalformedURLException e) {
            return null;
        }
        requestProto.setHost(url.getHost().isEmpty() ? httpRequest.headers().get((CharSequence)HttpHeaderNames.HOST) : url.getHost());
        requestProto.setPort(url.getPort() != -1 ? url.getPort() : url.getDefaultPort());
        requestProto.setProxy(httpRequest.headers().contains((CharSequence)HttpHeaderNames.PROXY_CONNECTION));
        return requestProto;
    }

    public static class RequestProto
    implements Serializable {
        private static final long serialVersionUID = -6471051659605127698L;
        private boolean proxy;
        private String host;
        private int port;
        private boolean ssl;

        public RequestProto() {
        }

        public RequestProto(String host, int port, boolean ssl) {
            this.host = host;
            this.port = port;
            this.ssl = ssl;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public boolean getSsl() {
            return this.ssl;
        }

        public void setSsl(boolean ssl) {
            this.ssl = ssl;
        }

        public boolean getProxy() {
            return this.proxy;
        }

        public void setProxy(boolean proxy) {
            this.proxy = proxy;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RequestProto that = (RequestProto)o;
            return this.port == that.port && this.ssl == that.ssl && this.host.equals(that.host);
        }

        public int hashCode() {
            return Objects.hash(this.host, this.port, this.ssl);
        }

        public RequestProto copy() {
            RequestProto requestProto = new RequestProto();
            requestProto.setProxy(this.proxy);
            requestProto.setHost(this.host);
            requestProto.setPort(this.port);
            requestProto.setSsl(this.ssl);
            return requestProto;
        }
    }
}

