/*
 * Decompiled with CFR 0.152.
 */
package com.github.pagehelper;

import com.github.pagehelper.Constant;
import com.github.pagehelper.Page;
import com.github.pagehelper.parser.Parser;
import com.github.pagehelper.sqlsource.PageDynamicSqlSource;
import com.github.pagehelper.sqlsource.PageProviderSqlSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.builder.StaticSqlSource;
import org.apache.ibatis.builder.annotation.ProviderSqlSource;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.scripting.xmltags.DynamicSqlSource;
import org.apache.ibatis.scripting.xmltags.MixedSqlNode;
import org.apache.ibatis.scripting.xmltags.SqlNode;
import org.apache.ibatis.session.Configuration;

public class MSUtils
implements Constant {
    private static final List<ResultMapping> EMPTY_RESULTMAPPING = new ArrayList<ResultMapping>(0);
    private Parser parser;

    public MSUtils(Parser parser) {
        this.parser = parser;
    }

    public void processCountMappedStatement(MappedStatement ms, SqlSource sqlSource, Object[] args) {
        args[0] = this.getMappedStatement(ms, sqlSource, args[1], "_PageHelper_Count");
    }

    public void processPageMappedStatement(MappedStatement ms, SqlSource sqlSource, Page page, Object[] args) {
        args[0] = this.getMappedStatement(ms, sqlSource, args[1], "_PageHelper");
        args[1] = this.setPageParameter((MappedStatement)args[0], args[1], page);
    }

    public Map setPageParameter(MappedStatement ms, Object parameterObject, Page page) {
        BoundSql boundSql = ms.getBoundSql(parameterObject);
        return this.parser.setPageParameter(ms, parameterObject, boundSql, page);
    }

    public MappedStatement getMappedStatement(MappedStatement ms, SqlSource sqlSource, Object parameterObject, String suffix) {
        MappedStatement qs = null;
        if (ms.getId().endsWith("_PageHelper") || ms.getId().endsWith("_PageHelper_Count")) {
            throw new RuntimeException("\u5206\u9875\u63d2\u4ef6\u914d\u7f6e\u9519\u8bef:\u8bf7\u4e0d\u8981\u5728\u7cfb\u7edf\u4e2d\u914d\u7f6e\u591a\u4e2a\u5206\u9875\u63d2\u4ef6(\u4f7f\u7528Spring\u65f6,mybatis-config.xml\u548cSpring<bean>\u914d\u7f6e\u65b9\u5f0f\uff0c\u8bf7\u9009\u62e9\u5176\u4e2d\u4e00\u79cd\uff0c\u4e0d\u8981\u540c\u65f6\u914d\u7f6e\u591a\u4e2a\u5206\u9875\u63d2\u4ef6)\uff01");
        }
        if (this.parser.isSupportedMappedStatementCache()) {
            try {
                qs = ms.getConfiguration().getMappedStatement(ms.getId() + suffix);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (qs == null) {
            qs = this.newMappedStatement(ms, this.getsqlSource(ms, sqlSource, parameterObject, suffix == "_PageHelper_Count"), suffix);
            if (this.parser.isSupportedMappedStatementCache()) {
                try {
                    ms.getConfiguration().addMappedStatement(qs);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return qs;
    }

    public MappedStatement newMappedStatement(MappedStatement ms, SqlSource sqlSource, String suffix) {
        String id = ms.getId() + suffix;
        MappedStatement.Builder builder = new MappedStatement.Builder(ms.getConfiguration(), id, sqlSource, ms.getSqlCommandType());
        builder.resource(ms.getResource());
        builder.fetchSize(ms.getFetchSize());
        builder.statementType(ms.getStatementType());
        builder.keyGenerator(ms.getKeyGenerator());
        if (ms.getKeyProperties() != null && ms.getKeyProperties().length != 0) {
            StringBuilder keyProperties = new StringBuilder();
            for (String keyProperty : ms.getKeyProperties()) {
                keyProperties.append(keyProperty).append(",");
            }
            keyProperties.delete(keyProperties.length() - 1, keyProperties.length());
            builder.keyProperty(keyProperties.toString());
        }
        builder.timeout(ms.getTimeout());
        builder.parameterMap(ms.getParameterMap());
        if (suffix == "_PageHelper") {
            builder.resultMaps(ms.getResultMaps());
        } else {
            ArrayList<ResultMap> resultMaps = new ArrayList<ResultMap>();
            ResultMap resultMap = new ResultMap.Builder(ms.getConfiguration(), id, Integer.TYPE, EMPTY_RESULTMAPPING).build();
            resultMaps.add(resultMap);
            builder.resultMaps(resultMaps);
        }
        builder.resultSetType(ms.getResultSetType());
        builder.cache(ms.getCache());
        builder.flushCacheRequired(ms.isFlushCacheRequired());
        builder.useCache(ms.isUseCache());
        return builder.build();
    }

    public SqlSource getsqlSource(MappedStatement ms, SqlSource sqlSource, Object parameterObject, boolean count) {
        if (sqlSource instanceof DynamicSqlSource) {
            MixedSqlNode mixedSqlNode;
            MetaObject msObject = SystemMetaObject.forObject((Object)ms);
            SqlNode sqlNode = (SqlNode)msObject.getValue("sqlSource.rootSqlNode");
            if (sqlNode instanceof MixedSqlNode) {
                mixedSqlNode = (MixedSqlNode)sqlNode;
            } else {
                ArrayList<SqlNode> contents = new ArrayList<SqlNode>(1);
                contents.add(sqlNode);
                mixedSqlNode = new MixedSqlNode(contents);
            }
            return new PageDynamicSqlSource(this, ms.getConfiguration(), (SqlNode)mixedSqlNode, count);
        }
        if (sqlSource instanceof ProviderSqlSource) {
            return new PageProviderSqlSource(this.parser, ms.getConfiguration(), (ProviderSqlSource)sqlSource, count);
        }
        if (count) {
            return this.getStaticCountSqlSource(ms.getConfiguration(), sqlSource, parameterObject);
        }
        return this.getStaticPageSqlSource(ms.getConfiguration(), sqlSource, parameterObject);
    }

    public SqlSource getStaticPageSqlSource(Configuration configuration, SqlSource sqlSource, Object parameterObject) {
        BoundSql boundSql = sqlSource.getBoundSql(parameterObject);
        return new StaticSqlSource(configuration, this.parser.getPageSql(boundSql.getSql()), this.parser.getPageParameterMapping(configuration, boundSql));
    }

    public SqlSource getStaticCountSqlSource(Configuration configuration, SqlSource sqlSource, Object parameterObject) {
        BoundSql boundSql = sqlSource.getBoundSql(parameterObject);
        return new StaticSqlSource(configuration, this.parser.getCountSql(boundSql.getSql()), boundSql.getParameterMappings());
    }
}

