/*
 * Decompiled with CFR 0.152.
 */
package com.github.pagehelper.sqlsource;

import com.github.pagehelper.Constant;
import com.github.pagehelper.MSUtils;
import java.util.Map;
import org.apache.ibatis.builder.SqlSourceBuilder;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.scripting.xmltags.DynamicContext;
import org.apache.ibatis.scripting.xmltags.SqlNode;
import org.apache.ibatis.session.Configuration;

public class PageDynamicSqlSource
implements SqlSource,
Constant {
    private Configuration configuration;
    private SqlNode rootSqlNode;
    private Boolean count;
    private MSUtils msUtils;

    public PageDynamicSqlSource(MSUtils msUtils, Configuration configuration, SqlNode rootSqlNode, Boolean count) {
        this.msUtils = msUtils;
        this.configuration = configuration;
        this.rootSqlNode = rootSqlNode;
        this.count = count;
    }

    public BoundSql getBoundSql(Object parameterObject) {
        DynamicContext context = parameterObject != null && parameterObject instanceof Map && ((Map)parameterObject).containsKey("_ORIGINAL_PARAMETER_OBJECT") ? new DynamicContext(this.configuration, ((Map)parameterObject).get("_ORIGINAL_PARAMETER_OBJECT")) : new DynamicContext(this.configuration, parameterObject);
        this.rootSqlNode.apply(context);
        SqlSourceBuilder sqlSourceParser = new SqlSourceBuilder(this.configuration);
        Class parameterType = parameterObject == null ? Object.class : parameterObject.getClass();
        SqlSource sqlSource = sqlSourceParser.parse(context.getSql(), parameterType, context.getBindings());
        sqlSource = this.count != false ? this.msUtils.getStaticCountSqlSource(this.configuration, sqlSource, parameterObject) : this.msUtils.getStaticPageSqlSource(this.configuration, sqlSource, parameterObject);
        BoundSql boundSql = sqlSource.getBoundSql(parameterObject);
        for (Map.Entry entry : context.getBindings().entrySet()) {
            boundSql.setAdditionalParameter((String)entry.getKey(), entry.getValue());
        }
        return boundSql;
    }
}

