/*
 * Decompiled with CFR 0.152.
 */
package com.github.orderbyhelper.sqlsource;

import com.github.orderbyhelper.OrderByHelper;
import com.github.orderbyhelper.OrderByParser;
import com.github.orderbyhelper.sqlsource.OrderBySqlSource;
import java.util.List;
import org.apache.ibatis.builder.StaticSqlSource;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.Configuration;

public class OrderByStaticSqlSource
implements SqlSource,
OrderBySqlSource {
    private String sql;
    private List<ParameterMapping> parameterMappings;
    private Configuration configuration;
    private SqlSource original;

    public OrderByStaticSqlSource(StaticSqlSource sqlSource) {
        MetaObject metaObject = SystemMetaObject.forObject((Object)sqlSource);
        this.sql = (String)metaObject.getValue("sql");
        this.parameterMappings = (List)metaObject.getValue("parameterMappings");
        this.configuration = (Configuration)metaObject.getValue("configuration");
        this.original = sqlSource;
    }

    public BoundSql getBoundSql(Object parameterObject) {
        String orderBy = OrderByHelper.getOrderBy();
        String tempSql = this.sql;
        if (orderBy != null) {
            tempSql = OrderByParser.converToOrderBySql(this.sql, orderBy);
        }
        return new BoundSql(this.configuration, tempSql, this.parameterMappings, parameterObject);
    }

    @Override
    public SqlSource getOriginal() {
        return this.original;
    }
}

