/*
 * Decompiled with CFR 0.152.
 */
package com.github.pagehelper.sqlsource;

import com.github.orderbyhelper.sqlsource.OrderBySqlSource;
import com.github.orderbyhelper.sqlsource.OrderByStaticSqlSource;
import com.github.pagehelper.Constant;
import com.github.pagehelper.parser.Parser;
import com.github.pagehelper.sqlsource.PageSqlSource;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.ibatis.builder.BuilderException;
import org.apache.ibatis.builder.SqlSourceBuilder;
import org.apache.ibatis.builder.StaticSqlSource;
import org.apache.ibatis.builder.annotation.ProviderSqlSource;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.Configuration;

public class PageProviderSqlSource
extends PageSqlSource
implements OrderBySqlSource,
Constant {
    private SqlSourceBuilder sqlSourceParser;
    private Class<?> providerType;
    private Method providerMethod;
    private Boolean providerTakesParameterObject;
    private SqlSource original;
    private Configuration configuration;
    private Parser parser;

    public PageProviderSqlSource(ProviderSqlSource provider, Parser parser) {
        MetaObject metaObject = SystemMetaObject.forObject((Object)provider);
        this.sqlSourceParser = (SqlSourceBuilder)metaObject.getValue("sqlSourceParser");
        this.providerType = (Class)metaObject.getValue("providerType");
        this.providerMethod = (Method)metaObject.getValue("providerMethod");
        this.providerTakesParameterObject = (Boolean)metaObject.getValue("providerTakesParameterObject");
        this.configuration = (Configuration)metaObject.getValue("sqlSourceParser.configuration");
        this.original = provider;
        this.parser = parser;
    }

    private SqlSource createSqlSource(Object parameterObject) {
        try {
            String sql = this.providerTakesParameterObject != false ? (String)this.providerMethod.invoke(this.providerType.newInstance(), parameterObject) : (String)this.providerMethod.invoke(this.providerType.newInstance(), new Object[0]);
            Class parameterType = parameterObject == null ? Object.class : parameterObject.getClass();
            StaticSqlSource sqlSource = (StaticSqlSource)this.sqlSourceParser.parse(sql, parameterType, new HashMap());
            return new OrderByStaticSqlSource(sqlSource);
        }
        catch (Exception e) {
            throw new BuilderException("Error invoking SqlProvider method (" + this.providerType.getName() + "." + this.providerMethod.getName() + ").  Cause: " + e, (Throwable)e);
        }
    }

    @Override
    protected BoundSql getDefaultBoundSql(Object parameterObject) {
        SqlSource sqlSource = this.createSqlSource(parameterObject);
        return sqlSource.getBoundSql(parameterObject);
    }

    @Override
    protected BoundSql getCountBoundSql(Object parameterObject) {
        SqlSource sqlSource = this.createSqlSource(parameterObject);
        BoundSql boundSql = sqlSource.getBoundSql(parameterObject);
        return new BoundSql(this.configuration, this.parser.getCountSql(boundSql.getSql()), boundSql.getParameterMappings(), parameterObject);
    }

    @Override
    protected BoundSql getPageBoundSql(Object parameterObject) {
        BoundSql boundSql;
        if (parameterObject instanceof Map && ((Map)parameterObject).containsKey("_provider_object")) {
            SqlSource sqlSource = this.createSqlSource(((Map)parameterObject).get("_provider_object"));
            boundSql = sqlSource.getBoundSql(((Map)parameterObject).get("_provider_object"));
        } else {
            SqlSource sqlSource = this.createSqlSource(parameterObject);
            boundSql = sqlSource.getBoundSql(parameterObject);
        }
        return new BoundSql(this.configuration, this.parser.getPageSql(boundSql.getSql()), this.parser.getPageParameterMapping(this.configuration, boundSql), parameterObject);
    }

    @Override
    public SqlSource getOriginal() {
        return this.original;
    }
}

