/*
 * Decompiled with CFR 0.152.
 */
package com.github.pagehelper.sqlsource;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.parser.OrderByParser;
import com.github.pagehelper.parser.Parser;
import com.github.pagehelper.sqlsource.PageSqlSource;
import java.util.List;
import org.apache.ibatis.builder.StaticSqlSource;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.Configuration;

public class PageStaticSqlSource
extends PageSqlSource {
    private String sql;
    private List<ParameterMapping> parameterMappings;
    private Configuration configuration;
    private SqlSource original;

    public PageStaticSqlSource(StaticSqlSource sqlSource) {
        MetaObject metaObject = SystemMetaObject.forObject((Object)sqlSource);
        this.sql = (String)metaObject.getValue("sql");
        this.parameterMappings = (List)metaObject.getValue("parameterMappings");
        this.configuration = (Configuration)metaObject.getValue("configuration");
        this.original = sqlSource;
    }

    @Override
    protected BoundSql getDefaultBoundSql(Object parameterObject) {
        String tempSql = this.sql;
        String orderBy = PageHelper.getOrderBy();
        if (orderBy != null) {
            tempSql = OrderByParser.converToOrderBySql(this.sql, orderBy);
        }
        return new BoundSql(this.configuration, tempSql, this.parameterMappings, parameterObject);
    }

    @Override
    protected BoundSql getCountBoundSql(Object parameterObject) {
        return new BoundSql(this.configuration, ((Parser)localParser.get()).getCountSql(this.sql), this.parameterMappings, parameterObject);
    }

    @Override
    protected BoundSql getPageBoundSql(Object parameterObject) {
        String tempSql = this.sql;
        String orderBy = PageHelper.getOrderBy();
        if (orderBy != null) {
            tempSql = OrderByParser.converToOrderBySql(this.sql, orderBy);
        }
        tempSql = ((Parser)localParser.get()).getPageSql(tempSql);
        return new BoundSql(this.configuration, tempSql, ((Parser)localParser.get()).getPageParameterMapping(this.configuration, this.original.getBoundSql(parameterObject)), parameterObject);
    }
}

