/*
 * Decompiled with CFR 0.152.
 */
package com.github.pagehelper;

import com.github.pagehelper.Dialect;
import com.github.pagehelper.util.MSUtils;
import com.github.pagehelper.util.StringUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class PaginationInterceptor
implements Interceptor {
    protected Dialect dialect;
    protected Field additionalParametersField;

    public Object intercept(Invocation invocation) throws Throwable {
        List resultList;
        RowBounds rowBounds;
        Object parameterObject;
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement)args[0];
        if (!this.dialect.skip(ms, parameterObject = args[1], rowBounds = (RowBounds)args[2])) {
            ResultHandler resultHandler = (ResultHandler)args[3];
            Executor executor = (Executor)invocation.getTarget();
            BoundSql boundSql = ms.getBoundSql(parameterObject);
            Map additionalParameters = (Map)this.additionalParametersField.get(boundSql);
            if (this.dialect.beforeCount(ms, parameterObject, rowBounds)) {
                CacheKey countKey = executor.createCacheKey(ms, parameterObject, RowBounds.DEFAULT, boundSql);
                countKey.update((Object)"_Count");
                MappedStatement countMs = MSUtils.newCountMappedStatement(ms);
                String countSql = this.dialect.getCountSql(ms, boundSql, parameterObject, rowBounds, countKey);
                BoundSql countBoundSql = new BoundSql(ms.getConfiguration(), countSql, boundSql.getParameterMappings(), parameterObject);
                for (String key : additionalParameters.keySet()) {
                    countBoundSql.setAdditionalParameter(key, additionalParameters.get(key));
                }
                List countResultList = executor.query(countMs, parameterObject, RowBounds.DEFAULT, resultHandler, countKey, countBoundSql);
                Long count = (Long)countResultList.get(0);
                this.dialect.afterCount(count, parameterObject, rowBounds);
                if (count == 0L) {
                    return this.dialect.afterPage(new ArrayList(), parameterObject, rowBounds);
                }
            }
            if (this.dialect.beforePage(ms, parameterObject, rowBounds)) {
                CacheKey pageKey = executor.createCacheKey(ms, parameterObject, rowBounds, boundSql);
                parameterObject = this.dialect.processParameterObject(ms, parameterObject, boundSql, pageKey);
                String pageSql = this.dialect.getPageSql(ms, boundSql, parameterObject, rowBounds, pageKey);
                BoundSql pageBoundSql = new BoundSql(ms.getConfiguration(), pageSql, boundSql.getParameterMappings(), parameterObject);
                for (String key : additionalParameters.keySet()) {
                    pageBoundSql.setAdditionalParameter(key, additionalParameters.get(key));
                }
                resultList = executor.query(ms, parameterObject, RowBounds.DEFAULT, resultHandler, pageKey, pageBoundSql);
            } else {
                resultList = new ArrayList();
            }
        } else {
            args[2] = RowBounds.DEFAULT;
            resultList = (ArrayList)invocation.proceed();
        }
        return this.dialect.afterPage(resultList, parameterObject, rowBounds);
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
        String dialectClassStr = properties.getProperty("dialect");
        if (StringUtil.isEmpty(dialectClassStr)) {
            throw new RuntimeException("\u4f7f\u7528 PaginationInterceptor \u5206\u9875\u63d2\u4ef6\u65f6\uff0c\u5fc5\u987b\u8bbe\u7f6e dialect \u5c5e\u6027");
        }
        try {
            Class<?> dialectClass = Class.forName(dialectClassStr);
            this.dialect = (Dialect)dialectClass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u521d\u59cb\u5316 dialect [" + dialectClassStr + "]\u65f6\u51fa\u9519:" + e.getMessage());
        }
        this.dialect.setProperties(properties);
        try {
            this.additionalParametersField = BoundSql.class.getDeclaredField("additionalParameters");
            this.additionalParametersField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

