/*
 * Decompiled with CFR 0.152.
 */
package com.github.pagehelper.cache;

import com.github.pagehelper.cache.Cache;
import com.github.pagehelper.util.StringUtil;
import java.util.Properties;
import org.apache.ibatis.cache.decorators.FifoCache;
import org.apache.ibatis.cache.impl.PerpetualCache;
import org.apache.ibatis.mapping.CacheBuilder;

public class SimpleCache<K, V>
implements Cache<K, V> {
    private final org.apache.ibatis.cache.Cache CACHE;

    public SimpleCache(Properties properties, String prefix) {
        String size;
        CacheBuilder cacheBuilder = new CacheBuilder("SQL_CACHE");
        String typeClass = properties.getProperty(prefix + ".typeClass");
        if (StringUtil.isNotEmpty(typeClass)) {
            try {
                cacheBuilder.implementation(Class.forName(typeClass));
            }
            catch (ClassNotFoundException e) {
                cacheBuilder.implementation(PerpetualCache.class);
            }
        } else {
            cacheBuilder.implementation(PerpetualCache.class);
        }
        String evictionClass = properties.getProperty(prefix + ".evictionClass");
        if (StringUtil.isNotEmpty(evictionClass)) {
            try {
                cacheBuilder.addDecorator(Class.forName(evictionClass));
            }
            catch (ClassNotFoundException e) {
                cacheBuilder.addDecorator(FifoCache.class);
            }
        } else {
            cacheBuilder.addDecorator(FifoCache.class);
        }
        String flushInterval = properties.getProperty(prefix + ".flushInterval");
        if (StringUtil.isNotEmpty(flushInterval)) {
            cacheBuilder.clearInterval(Long.valueOf(Long.parseLong(flushInterval)));
        }
        if (StringUtil.isNotEmpty(size = properties.getProperty(prefix + ".size"))) {
            cacheBuilder.size(Integer.valueOf(Integer.parseInt(size)));
        }
        cacheBuilder.properties(properties);
        this.CACHE = cacheBuilder.build();
    }

    @Override
    public V get(K key) {
        Object value = this.CACHE.getObject(key);
        if (value != null) {
            return (V)value.toString();
        }
        return null;
    }

    @Override
    public void put(K key, V value) {
        this.CACHE.putObject(key, value);
    }
}

