/*
 * Decompiled with CFR 0.152.
 */
package com.github.pagehelper.util;

import com.github.pagehelper.Constant;
import com.github.pagehelper.Dialect;
import com.github.pagehelper.dialect.AbstractDialect;
import com.github.pagehelper.util.BaseSqlUtil;
import com.github.pagehelper.util.MSUtils;
import com.github.pagehelper.util.StringUtil;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.sql.DataSource;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

public class SqlUtil
extends BaseSqlUtil
implements Constant {
    private Dialect dialect;
    private Field additionalParametersField;
    private Properties properties;
    protected boolean autoDialect = true;
    protected boolean autoRuntimeDialect;
    protected boolean closeConn = true;
    private Map<String, Dialect> urlDialectMap = new ConcurrentHashMap<String, Dialect>();
    private ReentrantLock lock = new ReentrantLock();

    public Object intercept(Invocation invocation) throws Throwable {
        try {
            Object object = this.doIntercept(invocation);
            return object;
        }
        finally {
            SqlUtil.clearLocalPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doIntercept(Invocation invocation) throws Throwable {
        List resultList;
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement)args[0];
        Object parameterObject = args[1];
        RowBounds rowBounds = (RowBounds)args[2];
        if (this.autoDialect) {
            this.lock.lock();
            try {
                if (this.autoDialect) {
                    this.autoDialect = false;
                    this.dialect = this.getDialect(ms);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        Dialect runtimeDialect = this.dialect;
        if (this.autoRuntimeDialect) {
            runtimeDialect = this.getDialect(ms);
        }
        if (!runtimeDialect.skip(ms, parameterObject, rowBounds)) {
            ResultHandler resultHandler = (ResultHandler)args[3];
            Executor executor = (Executor)invocation.getTarget();
            BoundSql boundSql = ms.getBoundSql(parameterObject);
            Map additionalParameters = (Map)this.additionalParametersField.get(boundSql);
            if (runtimeDialect.beforeCount(ms, parameterObject, rowBounds)) {
                CacheKey countKey = executor.createCacheKey(ms, parameterObject, RowBounds.DEFAULT, boundSql);
                countKey.update((Object)"_Count");
                MappedStatement countMs = (MappedStatement)this.msCountMap.get(countKey);
                if (countMs == null) {
                    countMs = MSUtils.newCountMappedStatement(ms);
                    this.msCountMap.put(countKey, countMs);
                }
                String countSql = runtimeDialect.getCountSql(ms, boundSql, parameterObject, rowBounds, countKey);
                BoundSql countBoundSql = new BoundSql(ms.getConfiguration(), countSql, boundSql.getParameterMappings(), parameterObject);
                for (String key : additionalParameters.keySet()) {
                    countBoundSql.setAdditionalParameter(key, additionalParameters.get(key));
                }
                List countResultList = executor.query(countMs, parameterObject, RowBounds.DEFAULT, resultHandler, countKey, countBoundSql);
                Long count = (Long)countResultList.get(0);
                runtimeDialect.afterCount(count, parameterObject, rowBounds);
                if (count == 0L) {
                    return runtimeDialect.afterPage(new ArrayList(), parameterObject, rowBounds);
                }
            }
            if (runtimeDialect.beforePage(ms, parameterObject, rowBounds)) {
                CacheKey pageKey = executor.createCacheKey(ms, parameterObject, rowBounds, boundSql);
                parameterObject = runtimeDialect.processParameterObject(ms, parameterObject, boundSql, pageKey);
                String pageSql = runtimeDialect.getPageSql(ms, boundSql, parameterObject, rowBounds, pageKey);
                BoundSql pageBoundSql = new BoundSql(ms.getConfiguration(), pageSql, boundSql.getParameterMappings(), parameterObject);
                for (String key : additionalParameters.keySet()) {
                    pageBoundSql.setAdditionalParameter(key, additionalParameters.get(key));
                }
                resultList = executor.query(ms, parameterObject, RowBounds.DEFAULT, resultHandler, pageKey, pageBoundSql);
            } else {
                resultList = new ArrayList();
            }
        } else {
            args[2] = RowBounds.DEFAULT;
            resultList = (ArrayList)invocation.proceed();
        }
        return runtimeDialect.afterPage(resultList, parameterObject, rowBounds);
    }

    private Dialect initDialect(String dialectClass, Properties properties) {
        Dialect dialect;
        if (StringUtil.isEmpty(dialectClass)) {
            throw new RuntimeException("\u4f7f\u7528 PageHelper \u5206\u9875\u63d2\u4ef6\u65f6\uff0c\u5fc5\u987b\u8bbe\u7f6e dialect \u5c5e\u6027");
        }
        try {
            Class sqlDialectClass = SqlUtil.resloveDialectClass(dialectClass);
            dialect = AbstractDialect.class.isAssignableFrom(sqlDialectClass) ? (Dialect)sqlDialectClass.getConstructor(SqlUtil.class).newInstance(this) : (Dialect)sqlDialectClass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u521d\u59cb\u5316 dialect [" + dialectClass + "]\u65f6\u51fa\u9519:" + e.getMessage());
        }
        dialect.setProperties(properties);
        return dialect;
    }

    public String getUrl(DataSource dataSource) {
        Connection conn = null;
        try {
            conn = dataSource.getConnection();
            String string = conn.getMetaData().getURL();
            return string;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (conn != null) {
                try {
                    if (this.closeConn) {
                        conn.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dialect getDialect(MappedStatement ms) {
        DataSource dataSource = ms.getConfiguration().getEnvironment().getDataSource();
        String url = this.getUrl(dataSource);
        if (this.urlDialectMap.containsKey(url)) {
            return this.urlDialectMap.get(url);
        }
        try {
            this.lock.lock();
            if (this.urlDialectMap.containsKey(url)) {
                Dialect dialect = this.urlDialectMap.get(url);
                return dialect;
            }
            if (StringUtil.isEmpty(url)) {
                throw new RuntimeException("\u65e0\u6cd5\u81ea\u52a8\u83b7\u53d6jdbcUrl\uff0c\u8bf7\u5728\u5206\u9875\u63d2\u4ef6\u4e2d\u914d\u7f6edialect\u53c2\u6570!");
            }
            String dialectStr = SqlUtil.fromJdbcUrl(url);
            if (dialectStr == null) {
                throw new RuntimeException("\u65e0\u6cd5\u81ea\u52a8\u83b7\u53d6\u6570\u636e\u5e93\u7c7b\u578b\uff0c\u8bf7\u901a\u8fc7 dialect \u53c2\u6570\u6307\u5b9a!");
            }
            Dialect dialect = this.initDialect(dialectStr, this.properties);
            this.urlDialectMap.put(url, dialect);
            Dialect dialect2 = dialect;
            return dialect2;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void setProperties(Properties properties) {
        super.setProperties(properties);
        String closeConn = properties.getProperty("closeConn");
        if (StringUtil.isNotEmpty(closeConn)) {
            this.closeConn = Boolean.parseBoolean(closeConn);
        }
        String dialect = properties.getProperty("dialect");
        String runtimeDialect = properties.getProperty("autoRuntimeDialect");
        if (StringUtil.isNotEmpty(runtimeDialect) && runtimeDialect.equalsIgnoreCase("TRUE")) {
            this.autoRuntimeDialect = true;
            this.autoDialect = false;
            this.properties = properties;
        } else if (StringUtil.isEmpty(dialect)) {
            this.autoDialect = true;
            this.properties = properties;
        } else {
            this.autoDialect = false;
            this.dialect = this.initDialect(dialect, properties);
        }
        try {
            this.additionalParametersField = BoundSql.class.getDeclaredField("additionalParameters");
            this.additionalParametersField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

