/*
 * Decompiled with CFR 0.152.
 */
package com.github.pagehelper.page;

import com.github.pagehelper.ISelect;
import com.github.pagehelper.Page;
import com.github.pagehelper.util.PageObjectUtil;

public abstract class PageMethod {
    protected static final ThreadLocal<Page> LOCAL_PAGE = new ThreadLocal();

    protected static void setLocalPage(Page page) {
        LOCAL_PAGE.set(page);
    }

    public static <T> Page<T> getLocalPage() {
        return LOCAL_PAGE.get();
    }

    public static void clearPage() {
        LOCAL_PAGE.remove();
    }

    public static long count(ISelect select) {
        Page page = PageMethod.startPage(1, -1, true);
        select.doSelect();
        return page.getTotal();
    }

    public static <E> Page<E> startPage(Object params) {
        Page page = PageObjectUtil.getPageFromObject(params, true);
        Page oldPage = PageMethod.getLocalPage();
        if (oldPage != null && oldPage.isOrderByOnly()) {
            page.setOrderBy(oldPage.getOrderBy());
        }
        PageMethod.setLocalPage(page);
        return page;
    }

    public static <E> Page<E> startPage(int pageNum, int pageSize) {
        return PageMethod.startPage(pageNum, pageSize, true);
    }

    public static <E> Page<E> startPage(int pageNum, int pageSize, boolean count) {
        return PageMethod.startPage(pageNum, pageSize, count, null, null);
    }

    public static <E> Page<E> startPage(int pageNum, int pageSize, String orderBy) {
        Page<E> page = PageMethod.startPage(pageNum, pageSize);
        page.setOrderBy(orderBy);
        return page;
    }

    public static <E> Page<E> startPage(int pageNum, int pageSize, boolean count, Boolean reasonable, Boolean pageSizeZero) {
        Page page = new Page(pageNum, pageSize, count);
        page.setReasonable(reasonable);
        page.setPageSizeZero(pageSizeZero);
        Page oldPage = PageMethod.getLocalPage();
        if (oldPage != null && oldPage.isOrderByOnly()) {
            page.setOrderBy(oldPage.getOrderBy());
        }
        PageMethod.setLocalPage(page);
        return page;
    }

    public static <E> Page<E> offsetPage(int offset, int limit) {
        return PageMethod.offsetPage(offset, limit, true);
    }

    public static <E> Page<E> offsetPage(int offset, int limit, boolean count) {
        Page page = new Page(new int[]{offset, limit}, count);
        Page oldPage = PageMethod.getLocalPage();
        if (oldPage != null && oldPage.isOrderByOnly()) {
            page.setOrderBy(oldPage.getOrderBy());
        }
        PageMethod.setLocalPage(page);
        return page;
    }

    public static void orderBy(String orderBy) {
        Page<Object> page = PageMethod.getLocalPage();
        if (page != null) {
            page.setOrderBy(orderBy);
        } else {
            page = new Page();
            page.setOrderBy(orderBy);
            page.setOrderByOnly(true);
            PageMethod.setLocalPage(page);
        }
    }
}

