/*
 * Decompiled with CFR 0.152.
 */
package psiprobe.beans.accessors;

import java.util.Properties;
import oracle.jdbc.pool.OracleConnectionCacheManager;
import oracle.jdbc.pool.OracleDataSource;
import psiprobe.UtilsBase;
import psiprobe.beans.accessors.DatasourceAccessor;
import psiprobe.model.DataSourceInfo;

public class OracleDatasourceAccessor
implements DatasourceAccessor {
    @Override
    public DataSourceInfo getInfo(Object resource) throws Exception {
        DataSourceInfo dataSourceInfo = null;
        if (this.canMap(resource)) {
            OracleDataSource source = (OracleDataSource)resource;
            OracleConnectionCacheManager occm = OracleConnectionCacheManager.getConnectionCacheManagerInstance();
            Properties cacheProperties = source.getConnectionCacheProperties();
            String cacheName = source.getConnectionCacheName();
            String string = cacheName = cacheName != null && occm.existsCache(cacheName) ? cacheName : null;
            if (cacheProperties != null) {
                dataSourceInfo = new DataSourceInfo();
                if (cacheName != null) {
                    dataSourceInfo.setBusyConnections(occm.getNumberOfActiveConnections(cacheName));
                    dataSourceInfo.setEstablishedConnections(occm.getNumberOfAvailableConnections(cacheName) + dataSourceInfo.getBusyConnections());
                } else {
                    dataSourceInfo.setBusyConnections(0);
                    dataSourceInfo.setEstablishedConnections(0);
                }
                dataSourceInfo.setMaxConnections(UtilsBase.toInt(cacheProperties.getProperty("MaxLimit"), -1));
                dataSourceInfo.setJdbcUrl(source.getURL());
                dataSourceInfo.setUsername(source.getUser());
                dataSourceInfo.setResettable(true);
                dataSourceInfo.setType("oracle-jdbc");
            }
        }
        return dataSourceInfo;
    }

    @Override
    public boolean reset(Object resource) throws Exception {
        if (this.canMap(resource)) {
            ((OracleDataSource)resource).close();
            return true;
        }
        return false;
    }

    @Override
    public boolean canMap(Object resource) {
        return "oracle.jdbc.pool.OracleDataSource".equals(resource.getClass().getName()) && resource instanceof OracleDataSource;
    }
}

