/*
 * Decompiled with CFR 0.152.
 */
package com.power.common.util;

import com.power.common.util.DateTimeUtil;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Random;

public class RandomUtil {
    private static final String BASE_NUMBER = "0123456789";
    private static final String BASE_CHAR = "abcdefghijklmnopqrstuvwxyz";
    private static final String BASE_CHAR_NUMBER = "abcdefghijklmnopqrstuvwxyz0123456789";
    private static String FORMAT = "0.00";
    private static Random random = new Random();

    public static int randomInt(int min, int max) {
        return random.nextInt(max - min) + min;
    }

    public static int randomInt(int limit) {
        return random.nextInt(limit);
    }

    public static int randomInt() {
        return random.nextInt();
    }

    public static long randomLong() {
        return random.nextLong();
    }

    public static long randomLong(long min, long max) {
        long rangeLong = min + (long)(new Random().nextDouble() * (double)(max - min));
        return rangeLong;
    }

    public static String randomString(int length) {
        return RandomUtil.randomString(BASE_CHAR_NUMBER, length);
    }

    public static String randomNumbers(int length) {
        return RandomUtil.randomString(BASE_NUMBER, length);
    }

    public static String randomString(String baseString, int length) {
        StringBuffer sb = new StringBuffer();
        if (length < 1) {
            length = 1;
        }
        int baseLength = baseString.length();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(baseLength);
            sb.append(baseString.charAt(number));
        }
        return sb.toString();
    }

    public static double randomDouble(double min, double max) {
        return min + (max - min) * random.nextDouble();
    }

    public static double randomDouble() {
        return RandomUtil.randomDouble(0.0, 100.0);
    }

    public static String randomDouble(String format) {
        return new DecimalFormat(format).format(RandomUtil.randomDouble());
    }

    public static String randomValueByType(String type) {
        switch (type) {
            case "String": {
                return RandomUtil.randomString(6);
            }
            case "char": {
                return RandomUtil.randomString(1);
            }
            case "Integer": {
                return String.valueOf(RandomUtil.randomInt(1000));
            }
            case "int": {
                return String.valueOf(RandomUtil.randomInt(1000));
            }
            case "Long": {
                return String.valueOf(RandomUtil.randomInt(1000));
            }
            case "long": {
                return String.valueOf(RandomUtil.randomInt(1000));
            }
            case "Double": {
                return String.valueOf(RandomUtil.randomDouble(FORMAT));
            }
            case "double": {
                return String.valueOf(RandomUtil.randomDouble(FORMAT));
            }
            case "Float": {
                return String.valueOf(RandomUtil.randomDouble(FORMAT));
            }
            case "float": {
                return String.valueOf(RandomUtil.randomDouble(FORMAT));
            }
            case "short": {
                return String.valueOf(RandomUtil.randomInt(0, Short.MAX_VALUE));
            }
            case "Short": {
                return String.valueOf(RandomUtil.randomInt(0, Short.MAX_VALUE));
            }
            case "boolean": {
                return "true";
            }
            case "Boolean": {
                return "true";
            }
            case "BigDecimal": {
                return String.valueOf(RandomUtil.randomInt(1000));
            }
            case "BigInteger": {
                return String.valueOf(RandomUtil.randomInt(1000));
            }
            case "Time": {
                return DateTimeUtil.dateToStr(new Date(), "yyyy-MM-dd");
            }
            case "Date": {
                return DateTimeUtil.dateToStr(new Date(), "yyyy-MM-dd");
            }
            case "LocalDate": {
                return DateTimeUtil.long2Str(System.currentTimeMillis(), "yyyy-MM-dd");
            }
            case "Timestamp": {
                return DateTimeUtil.long2Str(System.currentTimeMillis(), "yyyy-MM-dd HH:mm:ss");
            }
            case "LocalDateTime": {
                return DateTimeUtil.long2Str(System.currentTimeMillis(), "yyyy-MM-dd HH:mm:ss");
            }
        }
        return RandomUtil.randomString(6);
    }
}

