/*
 * Decompiled with CFR 0.152.
 */
package com.power.common.util;

import com.power.common.util.StringUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ValidateUtil {
    public static final String EMAIL_PATTERN = "^[\\w!#$%&'*+/=?`{|}~^-]+(?:\\.[\\w!#$%&'*+/=?`{|}~^-]+)*@(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,6}$";
    public static final String CHINESE_PATTERN = "^[\u4e00-\u9fa5]{0,}$";
    public static final String CONTAINS_CHINESE_PATTERN = "[\u4e00-\u9fa5|\\\uff01|\\\uff0c|\\\u3002|\\\uff08|\\\uff09|\\\u300a|\\\u300b|\\\u201c|\\\u201d|\\\uff1f|\\\uff1a|\\\uff1b|\\\u3010|\\\u3011]";
    public static final String NUMBER_ADN_LETTER = "^[A-Za-z0-9]+$";
    public static final String QQ_PATTERN = "/[1-9][0-9]{4,}/";
    public static final String NUMBER_PATTERN = "[0-9]+";
    public static final String LETTER_PATTERN = "[a-zA-Z]+";
    public static final String ZIPCODE_PATTERN = "\\p{Digit}{6}";
    public static final String PHONE_PATTERN = "^(13[0-9]|14[579]|15[^4,\\D]|16[6]|17[0135678]|18[0-9]|19[89])\\d{8}$";
    public static final String TELEPHONE_PATTERN = "^(0\\d{2,3}-)?(\\d{7,8})(-(\\d{3,}))?$";
    public static final String TELEPHONE_400_PATTERN = "((400)(\\d{7}))|((400)-(\\d{3})-(\\d{4}))";
    public static final String IDCARD_PATTERN = "^((11|12|13|14|15|21|22|23|31|32|33|34|35|36|37|41|42|43|44|45|46|50|51|52|53|54|61|62|63|64|65|71|81|82|91)\\d{4})((((19|20)(([02468][048])|([13579][26]))0229))|((20[0-9][0-9])|(19[0-9][0-9]))((((0[1-9])|(1[0-2]))((0[1-9])|(1\\d)|(2[0-8])))|((((0[1,3-9])|(1[0-2]))(29|30))|(((0[13578])|(1[02]))31))))((\\d{3}(x|X))|(\\d{4}))$";
    public static final String USERNAME_PATTERN = "^[A-Za-z0-9_]{3,15}$";
    public static final String PASSWORD_PATTERN = "^(?![0-9]+$)[0-9A-Za-z]{6,20}$";
    public static final String UUID_PATTERN = "[0-9a-z]{8}-[0-9a-z]{4}-[0-9a-z]{4}-[0-9a-z]{4}-[0-9a-z]{12}";
    public static final String YEAR_PATTERN = "^(19|20)\\d{2}$";
    public static final String TIME_PATTERN = "^(?:(?:([01]?\\d|2[0-3]):)?([0-5]?\\d):)?([0-5]?\\d)$";
    public static final String DATE_PATTERN = "^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))";
    public static final String TIME_STAMP_PATTERN = "^((\\d{2}(([02468][048])|([13579][26]))[\\-\\s]?((((0?[13578])|(1[02]))[\\-\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\s]?((((0?[13578])|(1[02]))[\\-\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\s]?((0?[1-9])|(1[0-9])|(2[0-8])))))) ([2][0-3]|[0-1][0-9]|[1-9]):[0-5][0-9]:([0-5][0-9]|[6][0])$";
    public static final String IPV4_PATTERN = "([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])";
    public static final String IPV6_PATTERN = "([0-9a-f]+)\\:([0-9a-f]+)\\:([0-9a-f]+)\\:([0-9a-f]+)\\:([0-9a-f]+)\\:([0-9a-f]+)\\:([0-9a-f]+)\\:([0-9a-f]+)";
    public static final String URL_PATTERN = "^(http|https|ftp)\\://([a-zA-Z0-9\\.\\-]+(\\:[a-zA-Z0-9\\.&%\\$\\-]+)*@)?((25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9])\\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]|0)\\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]|0)\\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[0-9])|([a-zA-Z0-9\\-]+\\.)*[a-zA-Z0-9\\-]+\\.[a-zA-Z]{2,4})(\\:[0-9]+)?(/[^/][a-zA-Z0-9\\.\\,\\?\\'\\\\/\\+&%\\$#\\=~_\\-@]*)*$";
    public static final String DOMAIN_PATTERN = "^(?=^.{3,255}$)[a-zA-Z0-9][-a-zA-Z0-9]{0,62}(\\.[a-zA-Z0-9][-a-zA-Z0-9]{0,62})+$";
    public static final String INT_OR_FLOAT_PATTERN = "^\\d+\\.\\d+|\\d+$";
    public static final String FLOAT_PATTERN = "^(-?\\d+)(\\.\\d+)?$";
    public static final String POSITIVE_INTEGER = "[1-9]+\\d{0,10}";
    public static final String GIT_URL_PATTERN = "(git@[\\w\\.]+)(:(//)?)([\\w\\.@\\:/\\-~]+)(\\.git)(/)?";
    public static final String ARMY_ID_CARD = "\u5357\u5b57\u7b2c(\\d{6,8})\u53f7|\u5317\u5b57\u7b2c(\\d{6,8})\u53f7|\u6c88\u5b57\u7b2c(\\d{6,8})\u53f7|\u5170\u5b57\u7b2c(\\d{6,8})\u53f7|\u6210\u5b57\u7b2c(\\d{6,8})\u53f7|\u6d4e\u5b57\u7b2c(\\d{6,8})\u53f7|\u5e7f\u5b57\u7b2c(\\d{6,8})\u53f7|\u6d77\u5b57\u7b2c(\\d{6,8})\u53f7|\u7a7a\u5b57\u7b2c(\\d{6,8})\u53f7|\u53c2\u5b57\u7b2c(\\d{6,8})\u53f7|\u653f\u5b57\u7b2c(\\d{6,8})\u53f7|\u540e\u5b57\u7b2c(\\d{6,8})\u53f7|\u88c5\u5b57\u7b2c(\\d{6,8})\u53f7";
    public static final String[] forbidden = new String[]{"\\bselect\\b", "\\bor\\b", "\\bdelete\\b", "\\bjoin\\b", "\\btable\\b", "\\bdrop\\b", "\\biframe\\b", "\\bwindow\\b", "\\b_\\b", "\\+", "%", "\\<", "\\>", "'", "=", "%3C", "\\(", "%28", "alert", "eval((.*))", "script", "location.href"};

    public static boolean validate(String str, String pattern) {
        return StringUtil.isNotEmpty(str) && str.matches(pattern);
    }

    public static boolean isEmail(String email) {
        return ValidateUtil.validate(email, EMAIL_PATTERN);
    }

    public static boolean isNotEmail(String email) {
        return !ValidateUtil.isEmail(email);
    }

    public static boolean isChinese(String chineseStr) {
        return ValidateUtil.validate(chineseStr, CHINESE_PATTERN);
    }

    public static boolean isNotChinese(String chineseStr) {
        return !ValidateUtil.validate(chineseStr, CHINESE_PATTERN);
    }

    public static boolean isNumberLetter(String str) {
        return ValidateUtil.validate(str, NUMBER_ADN_LETTER);
    }

    public static boolean isNotNumberLetter(String str) {
        return !ValidateUtil.validate(str, NUMBER_ADN_LETTER);
    }

    public static boolean isQq(String qq) {
        return ValidateUtil.validate(qq, QQ_PATTERN);
    }

    public static boolean isNumber(String str) {
        return ValidateUtil.validate(str, NUMBER_PATTERN);
    }

    public static boolean isNotNumber(String str) {
        return !ValidateUtil.validate(str, NUMBER_PATTERN);
    }

    public static boolean isLetter(String str) {
        return ValidateUtil.validate(str, LETTER_PATTERN);
    }

    public static boolean isZipCode(String zipCode) {
        return ValidateUtil.validate(zipCode, ZIPCODE_PATTERN);
    }

    public static boolean isPhone(String phone) {
        return ValidateUtil.validate(phone, PHONE_PATTERN);
    }

    public static boolean isNotPhone(String phone) {
        return !ValidateUtil.isPhone(phone);
    }

    public static boolean isTelephone(String phoneNumber) {
        return ValidateUtil.validate(phoneNumber, TELEPHONE_PATTERN) || ValidateUtil.validate(phoneNumber, TELEPHONE_400_PATTERN);
    }

    public static boolean isNotTelephone(String phoneNumber) {
        return !ValidateUtil.isTelephone(phoneNumber);
    }

    public static boolean isIdCard(String cardNumber) {
        return ValidateUtil.validate(cardNumber, IDCARD_PATTERN);
    }

    public static boolean isNotIdCard(String cardNumber) {
        return !ValidateUtil.validate(cardNumber, IDCARD_PATTERN);
    }

    public static boolean isUserName(String str) {
        return ValidateUtil.validate(str, USERNAME_PATTERN);
    }

    public static boolean isPassword(String str) {
        return ValidateUtil.validate(str, PASSWORD_PATTERN);
    }

    public static boolean isNonNegativeInteger(String str) {
        return ValidateUtil.validate(str, "^\\d+$");
    }

    public static boolean isUuid(String str) {
        return ValidateUtil.validate(str, UUID_PATTERN) || ValidateUtil.validate(str, "[0-9a-z]{32}");
    }

    public static boolean isNotUuid(String str) {
        return !ValidateUtil.isUuid(str);
    }

    public static boolean isDate(String date) {
        return ValidateUtil.validate(date, DATE_PATTERN);
    }

    public static boolean isNotDate(String date) {
        return !ValidateUtil.validate(date, DATE_PATTERN);
    }

    public static boolean isTimestamp(String date) {
        return ValidateUtil.validate(date, TIME_STAMP_PATTERN);
    }

    public static boolean isNotTimestamp(String date) {
        return !ValidateUtil.validate(date, TIME_STAMP_PATTERN);
    }

    public static boolean isIP(String ip) {
        if (StringUtil.isEmpty(ip)) {
            return false;
        }
        return ValidateUtil.validate(ip = ip.toLowerCase(), IPV4_PATTERN) || ValidateUtil.validate(ip, IPV6_PATTERN);
    }

    public static boolean isNotIP(String ip) {
        return !ValidateUtil.isIP(ip);
    }

    public static boolean isUrl(String url) {
        return ValidateUtil.validate(url, URL_PATTERN);
    }

    public static boolean isNotUrl(String url) {
        return !ValidateUtil.validate(url, URL_PATTERN);
    }

    public static boolean isDomain(String domain) {
        return ValidateUtil.validate(domain, DOMAIN_PATTERN);
    }

    public static boolean isNotDomain(String domain) {
        return !ValidateUtil.validate(domain, DOMAIN_PATTERN);
    }

    public static boolean isIntOrFloat(String number) {
        return ValidateUtil.validate(number, INT_OR_FLOAT_PATTERN);
    }

    public static boolean isNotIntOrFloat(String number) {
        return !ValidateUtil.validate(number, INT_OR_FLOAT_PATTERN);
    }

    public static boolean isFloat(String number) {
        return ValidateUtil.validate(number, FLOAT_PATTERN);
    }

    public static boolean isNotFloat(String number) {
        return !ValidateUtil.validate(number, FLOAT_PATTERN);
    }

    public static boolean isNegativeFloat(String number) {
        return ValidateUtil.validate(number, "^(-((\\d+\\.\\d*[1-9]\\d*)|(\\d*[1-9]\\d*\\.\\d+)|(\\d*[1-9]\\d*)))$");
    }

    public static boolean isNotNegativeFloat(String number) {
        return !ValidateUtil.isNegativeFloat(number);
    }

    public static boolean isPositiveFloat(String number) {
        return ValidateUtil.validate(number, "^((\\d+\\.\\d*[1-9]\\d*)|(\\d*[1-9]\\d*\\.\\d+)|(\\d*[1-9]\\d*))$");
    }

    public static boolean isNotPositiveFloat(String number) {
        return !ValidateUtil.isPositiveFloat(number);
    }

    public static boolean isPositiveInteger(String number) {
        return ValidateUtil.validate(number, POSITIVE_INTEGER);
    }

    public static boolean isArmyIdCard(String armyIdCard) {
        return ValidateUtil.validate(armyIdCard, ARMY_ID_CARD);
    }

    public static boolean isNotArmyIdCard(String armyIdCard) {
        return !ValidateUtil.validate(armyIdCard, ARMY_ID_CARD);
    }

    public static boolean isContainsForbiddenCharacter(String number) {
        if (StringUtil.isEmpty(number)) {
            return false;
        }
        for (String reg : forbidden) {
            String me = (number = number.toLowerCase()).replaceAll(reg, "invalid character");
            if (me.length() == number.length()) continue;
            return true;
        }
        return false;
    }

    public static boolean isYear(String yearNumber) {
        return ValidateUtil.validate(yearNumber, YEAR_PATTERN);
    }

    public static boolean isNotYear(String yearNumber) {
        return !ValidateUtil.isYear(yearNumber);
    }

    public static boolean isTime(String time) {
        return ValidateUtil.validate(time, TIME_PATTERN);
    }

    public static boolean isNotTime(String time) {
        return !ValidateUtil.isTime(time);
    }

    public static boolean isContainsChinese(String str) {
        if (StringUtil.isEmpty(str)) {
            return true;
        }
        Pattern p = Pattern.compile(CONTAINS_CHINESE_PATTERN);
        Matcher m = p.matcher(str);
        return m.find();
    }

    public static boolean isGitUrl(String gitUrl) {
        return ValidateUtil.validate(gitUrl, GIT_URL_PATTERN);
    }
}

